/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.format;

import io.springlets.format.EntityFormat;
import io.springlets.format.EntityMessagePrinter;
import io.springlets.format.EntityParser;
import io.springlets.format.EntityPrinter;
import io.springlets.format.EntityResolver;
import io.springlets.format.EntityToStringConverter;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.EmbeddedValueResolutionSupport;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EntityFormatAnnotationFormatterFactory
extends EmbeddedValueResolutionSupport
implements AnnotationFormatterFactory<EntityFormat> {
    private static final Set<Class<?>> FIELD_TYPES;
    private static final SpelExpressionParser PARSER;
    private static final TemplateParserContext PARSER_CONTEXT;
    private final MessageSource messageSource;
    private final ConversionService conversionService;
    private final Map<Class<?>, EntityResolver<?, ?>> entity2Resolver;
    private String defaultExpression;

    public EntityFormatAnnotationFormatterFactory(MessageSource messageSource, ListableBeanFactory beanFactory, ConversionService conversionService) {
        this(messageSource, beanFactory, conversionService, "#{toString()}");
    }

    public EntityFormatAnnotationFormatterFactory(MessageSource messageSource, ListableBeanFactory beanFactory, ConversionService conversionService, String defaultExpression) {
        this.messageSource = messageSource;
        this.conversionService = conversionService;
        this.defaultExpression = defaultExpression;
        this.entity2Resolver = EntityFormatAnnotationFormatterFactory.loadEntityResolvers(beanFactory);
    }

    public Set<Class<?>> getFieldTypes() {
        return FIELD_TYPES;
    }

    public Printer<?> getPrinter(EntityFormat annotation, Class<?> fieldType) {
        EntityFormat fieldAnnotation = (EntityFormat)AnnotationUtils.getAnnotation((Annotation)annotation, EntityFormat.class);
        String messageCode = fieldAnnotation.message();
        if (!StringUtils.isEmpty((Object)messageCode)) {
            return this.createMessagePrinter(messageCode);
        }
        String expression = fieldAnnotation.expression();
        if (!StringUtils.isEmpty((Object)expression)) {
            return this.createPrinter(expression);
        }
        EntityFormat classAnnotation = (EntityFormat)AnnotatedElementUtils.findMergedAnnotation(fieldType, EntityFormat.class);
        if (classAnnotation != null) {
            messageCode = classAnnotation.message();
            if (!StringUtils.isEmpty((Object)messageCode)) {
                return this.createMessagePrinter(messageCode);
            }
            expression = classAnnotation.expression();
        }
        return this.createPrinter(expression);
    }

    public Parser<?> getParser(EntityFormat annotation, Class<?> fieldType) {
        Assert.notNull((Object)annotation, (String)"The EntityFormat annotation is required");
        Assert.notNull(fieldType, (String)"The Class of the field to parse is required");
        EntityResolver<?, ?> resolver = this.entity2Resolver.get(fieldType);
        if (resolver == null) {
            throw new IllegalArgumentException("Not found a required EntityService bean for the type: " + fieldType);
        }
        return new EntityParser(resolver, this.conversionService);
    }

    public ConditionalGenericConverter getToStringConverter() {
        return new EntityToStringConverter((ExpressionParser)PARSER, PARSER_CONTEXT, this.messageSource, this.conversionService);
    }

    private static Map<Class<?>, EntityResolver<?, ?>> loadEntityResolvers(ListableBeanFactory beanFactory) {
        Map entityServices = beanFactory.getBeansOfType(EntityResolver.class);
        HashMap entity2Resolver = new HashMap(entityServices.size());
        for (EntityResolver entityResolver : entityServices.values()) {
            entity2Resolver.put(entityResolver.getEntityType(), entityResolver);
        }
        return entity2Resolver;
    }

    private EntityPrinter createPrinter(String expression) {
        return new EntityPrinter(expression, (ExpressionParser)PARSER, PARSER_CONTEXT, this.conversionService, this.defaultExpression);
    }

    private EntityMessagePrinter createMessagePrinter(String messageCode) {
        return new EntityMessagePrinter(messageCode, this.messageSource, (ExpressionParser)PARSER, PARSER_CONTEXT, this.conversionService, this.defaultExpression);
    }

    static {
        HashSet<Class<Object>> fieldTypes = new HashSet<Class<Object>>(1);
        fieldTypes.add(Object.class);
        FIELD_TYPES = Collections.unmodifiableSet(fieldTypes);
        PARSER = new SpelExpressionParser();
        PARSER_CONTEXT = new TemplateParserContext();
    }
}

