/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.format;

import io.springlets.format.EntityExpressionSupport;
import io.springlets.format.EntityFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.util.StringUtils;

public class EntityToStringConverter
extends EntityExpressionSupport
implements ConditionalGenericConverter {
    private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES;
    private final MessageSource messageSource;

    public EntityToStringConverter(ExpressionParser parser, TemplateParserContext templateParserContext, MessageSource messageSource, ConversionService conversionService) {
        super(parser, templateParserContext, conversionService);
        this.messageSource = messageSource;
    }

    public EntityToStringConverter(ExpressionParser parser, TemplateParserContext templateParserContext, MessageSource messageSource) {
        super(parser, templateParserContext);
        this.messageSource = messageSource;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return CONVERTIBLE_TYPES;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        EntityFormat format = this.getAnnotation(sourceType.getType());
        String expressionTxt = this.getDefaultExpression();
        if (format != null) {
            if (!StringUtils.isEmpty((Object)format.message())) {
                expressionTxt = this.messageSource.getMessage(format.message(), null, null, this.getCurrentLocale());
            } else if (!StringUtils.isEmpty((Object)format.expression())) {
                expressionTxt = format.expression();
            }
        }
        return this.convertToString(source, expressionTxt);
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return String.class.equals((Object)targetType.getType()) && this.hasAnnotation(sourceType.getType());
    }

    private Locale getCurrentLocale() {
        return LocaleContextHolder.getLocale();
    }

    private boolean hasAnnotation(Class<?> clazz) {
        return AnnotatedElementUtils.hasAnnotation(clazz, EntityFormat.class);
    }

    private EntityFormat getAnnotation(Class<?> clazz) {
        return (EntityFormat)AnnotatedElementUtils.findMergedAnnotation(clazz, EntityFormat.class);
    }

    static {
        GenericConverter.ConvertiblePair pair = new GenericConverter.ConvertiblePair(Object.class, String.class);
        CONVERTIBLE_TYPES = Collections.singleton(pair);
    }
}

