/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.format;

import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

public class EnumToMessageConverter
implements GenericConverter {
    private static final String SEPARATOR = "_";
    private static final String ENUM_MESSAGE_CODE_PREFIX = "enum_";
    private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES;
    private final MessageSource messageSource;

    public EnumToMessageConverter(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return CONVERTIBLE_TYPES;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String name = ((Enum)source).name();
        String code = ENUM_MESSAGE_CODE_PREFIX + source.getClass().getSimpleName() + SEPARATOR + name;
        String message = this.messageSource.getMessage(code, null, name, this.getCurrentLocale());
        return message;
    }

    private Locale getCurrentLocale() {
        return LocaleContextHolder.getLocale();
    }

    static {
        GenericConverter.ConvertiblePair pair = new GenericConverter.ConvertiblePair(Enum.class, String.class);
        CONVERTIBLE_TYPES = Collections.singleton(pair);
    }
}

