/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.format.config;

import io.springlets.format.EntityFormatAnnotationFormatterFactory;
import io.springlets.format.EnumToMessageConverter;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class SpringletsEntityFormatWebConfiguration
extends WebMvcConfigurerAdapter {
    private final MessageSource messageSource;
    private final ApplicationContext applicationContext;

    @Autowired
    public SpringletsEntityFormatWebConfiguration(MessageSource messageSource, ApplicationContext applicationContext) {
        this.messageSource = messageSource;
        this.applicationContext = applicationContext;
    }

    public void addFormatters(FormatterRegistry registry) {
        super.addFormatters(registry);
        EntityFormatAnnotationFormatterFactory factory = new EntityFormatAnnotationFormatterFactory(this.messageSource, (ListableBeanFactory)this.applicationContext, (ConversionService)((FormattingConversionService)registry));
        registry.addFormatterForFieldAnnotation((AnnotationFormatterFactory)factory);
        registry.addConverter((GenericConverter)factory.getToStringConverter());
        registry.addConverter((GenericConverter)new EnumToMessageConverter(this.messageSource));
    }
}

