/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.validation;

import java.util.Collection;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

public class CollectionValidator
implements Validator {
    private final Validator validator;

    public CollectionValidator(LocalValidatorFactoryBean validatorFactory) {
        this.validator = validatorFactory;
    }

    public boolean supports(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        Collection collection = (Collection)target;
        int index = 0;
        for (Object object : collection) {
            BeanPropertyBindingResult elementErrors = new BeanPropertyBindingResult(object, errors.getObjectName());
            elementErrors.setNestedPath("[".concat(Integer.toString(index++)).concat("]."));
            ValidationUtils.invokeValidator((Validator)this.validator, object, (Errors)elementErrors);
            errors.addAllErrors((Errors)elementErrors);
        }
    }
}

