/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.directives;

import io.sundr.Function;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaKind;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.utils.StringUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.ASTBlock;
import org.apache.velocity.runtime.parser.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDirective
extends Directive {
    private static final JavaType OBJECT_TYPE = new JavaType(JavaKind.CLASS, "java.lang", "Object", false, false, true, null, null, null, new JavaType[0], Collections.<String, Object>emptyMap());
    private static final String MEMBER_OF = "MEMBER_OF";
    private static final String EXTENDS = " extends ";
    private static final String IMPLEMENTS = " implements ";
    private static final String PUBLIC = "public ";
    private static final String CLASS = "class";
    private static final String SPACE = " ";
    private static final String COMMA = ",";
    private static final String NEWLINE = "\n";
    private static final String BRACKETS_LR = "[]";
    private static final String SQUIGGLE_L = "{";
    private static final String SQUIGGLE_R = "}";
    private static final String LT = "<";
    private static final String GT = ">";

    public String getName() {
        return CLASS;
    }

    public int getType() {
        return 1;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException {
        String block = "";
        JavaClazz clazz = null;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) == null) continue;
            if (!(node.jjtGetChild(i) instanceof ASTBlock)) {
                if (i != 0) break;
                clazz = (JavaClazz)node.jjtGetChild(i).value(context);
                continue;
            }
            StringWriter blockContent = new StringWriter();
            node.jjtGetChild(i).render(context, (Writer)blockContent);
            block = blockContent.toString();
            break;
        }
        this.writeClazz(writer, clazz, block);
        return true;
    }

    private void writeClazz(Writer writer, JavaClazz clazz, String block) throws IOException {
        JavaTypeToString toString = new JavaTypeToString(ClassDirective.getEnclosingType(clazz));
        if (clazz != null) {
            JavaType type = clazz.getType();
            JavaKind kind = type.getKind() != null ? type.getKind() : JavaKind.CLASS;
            writer.append(PUBLIC).append(kind.name().toLowerCase()).append(SPACE);
            writer.append(toString.apply(type));
            this.writeExtends(writer, type, toString);
            this.writeImplements(writer, type, toString);
            writer.append(SQUIGGLE_L).append(NEWLINE);
            writer.append(block).append(NEWLINE).append(SQUIGGLE_R).append(NEWLINE);
        }
    }

    private void writeExtends(Writer writer, JavaType type, Function<JavaType, String> toString) throws IOException {
        if (type.getKind() != JavaKind.INTERFACE) {
            if (type.getSuperClass() != null && !OBJECT_TYPE.equals(type.getSuperClass())) {
                writer.append(EXTENDS).append((CharSequence)toString.apply((Object)type.getSuperClass()));
            }
        } else if (type.getInterfaces().size() > 0) {
            writer.append(EXTENDS).append(StringUtils.join(type.getInterfaces(), toString, COMMA));
        }
    }

    private void writeImplements(Writer writer, JavaType type, Function<JavaType, String> toString) throws IOException {
        if (type.getKind() != JavaKind.INTERFACE && type.getInterfaces().size() > 0) {
            writer.append(IMPLEMENTS).append(StringUtils.join(type.getInterfaces(), toString, COMMA));
        }
    }

    private static JavaType getEnclosingType(JavaClazz clazz) {
        Object obj = clazz.getAttributes().get(MEMBER_OF);
        if (obj instanceof JavaType) {
            return (JavaType)obj;
        }
        return clazz.getType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaTypeToString
    implements Function<JavaType, String> {
        private final JavaType enclosingType;

        JavaTypeToString(JavaType enclosingType) {
            this.enclosingType = enclosingType;
        }

        public String apply(JavaType item) {
            StringBuilder sb = new StringBuilder();
            if (item.getClassName().equals(this.enclosingType.getClassName()) && !item.getFullyQualifiedName().equals(this.enclosingType.getFullyQualifiedName())) {
                sb.append(item.getFullyQualifiedName());
            } else {
                sb.append(item.getClassName());
            }
            if (item.isArray()) {
                sb.append(ClassDirective.BRACKETS_LR);
            }
            if (item.getKind() == JavaKind.GENERIC && item.getSuperClass() != null) {
                sb.append(ClassDirective.EXTENDS).append(this.apply(item.getSuperClass()));
            }
            if (item.getGenericTypes() != null && item.getGenericTypes().length > 0) {
                sb.append(ClassDirective.LT).append(StringUtils.join(item.getGenericTypes(), this, ClassDirective.COMMA)).append(ClassDirective.GT);
            }
            return sb.toString();
        }
    }
}

