/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.maven.filter;

import io.sundr.maven.BomConfig;
import io.sundr.maven.BomImport;
import io.sundr.maven.filter.ArtifactFilter;
import io.sundr.maven.filter.CompositeFilter;
import io.sundr.maven.filter.ExcludesFilter;
import io.sundr.maven.filter.IncludePomsFilter;
import io.sundr.maven.filter.IncludesFilter;
import io.sundr.maven.filter.MavenPluginFilter;
import io.sundr.maven.filter.OptionalFilter;
import io.sundr.maven.filter.ScopeFilter;
import io.sundr.maven.filter.SessionArtifactFilter;
import io.sundr.maven.filter.SystemFilter;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;

public class Filters {
    public static final ArtifactFilter MAVEN_PLUGIN_FILTER = new MavenPluginFilter();
    public static final ArtifactFilter EXCLUDE_POM_FILTER = new IncludePomsFilter(false);

    private Filters() {
    }

    public static ArtifactFilter createDependencyFilter(MavenSession session, BomConfig config) {
        LinkedList<ArtifactFilter> filters = new LinkedList<ArtifactFilter>();
        filters.add(new SystemFilter());
        filters.add(new SessionArtifactFilter(session, false));
        filters.add(new IncludesFilter(config.getDependencies().getIncludes()));
        filters.add(new ExcludesFilter(config.getDependencies().getExcludes()));
        if (config.isExcludeOptional()) {
            filters.add(new OptionalFilter());
        }
        if (config.isIgnoreScope()) {
            filters.add(new ScopeFilter());
        }
        return new CompositeFilter(filters);
    }

    public static ArtifactFilter createModulesFilter(BomConfig config) {
        LinkedList<ArtifactFilter> filters = new LinkedList<ArtifactFilter>();
        filters.add(new SystemFilter());
        filters.add(EXCLUDE_POM_FILTER);
        filters.add(new IncludesFilter(config.getModules().getIncludes()));
        filters.add(new ExcludesFilter(config.getModules().getExcludes()));
        if (config.isExcludeOptional()) {
            filters.add(new OptionalFilter());
        }
        if (config.isIgnoreScope()) {
            filters.add(new ScopeFilter());
        }
        return new CompositeFilter(filters);
    }

    public static ArtifactFilter createPluginFilter(MavenSession session, BomConfig config) {
        LinkedList<ArtifactFilter> filters = new LinkedList<ArtifactFilter>();
        filters.add(MAVEN_PLUGIN_FILTER);
        filters.add(new IncludesFilter(config.getPlugins().getIncludes()));
        filters.add(new ExcludesFilter(config.getPlugins().getExcludes()));
        return new CompositeFilter(filters);
    }

    public static ArtifactFilter createDependencyManagementFilter(MavenSession session, BomImport bomImport) {
        LinkedList<ArtifactFilter> filters = new LinkedList<ArtifactFilter>();
        filters.add(new SystemFilter());
        filters.add(new SessionArtifactFilter(session, false));
        filters.add(new IncludesFilter(bomImport.getDependencyManagement().getIncludes()));
        filters.add(new ExcludesFilter(bomImport.getDependencyManagement().getExcludes()));
        return new CompositeFilter(filters);
    }

    public static Set<Artifact> filter(Set<Artifact> artifacts, ArtifactFilter filter) {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            Artifact filtered = filter.apply(artifact);
            if (filtered == null) continue;
            result.add(filtered);
        }
        return result;
    }

    public static <T> Map<Artifact, T> filter(Map<Artifact, T> dependencies, ArtifactFilter filter) {
        LinkedHashMap<Artifact, T> result = new LinkedHashMap<Artifact, T>();
        for (Map.Entry<Artifact, T> dependency : dependencies.entrySet()) {
            Artifact filtered = filter.apply(dependency.getKey());
            if (filtered == null) continue;
            result.put(filtered, dependency.getValue());
        }
        return result;
    }
}

