/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.controllers;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.io.Files;
import io.swagger.oas.inflector.config.Configuration;
import io.swagger.oas.inflector.config.ControllerFactory;
import io.swagger.oas.inflector.converters.ConversionException;
import io.swagger.oas.inflector.converters.InputConverter;
import io.swagger.oas.inflector.examples.ExampleBuilder;
import io.swagger.oas.inflector.examples.models.ArrayExample;
import io.swagger.oas.inflector.examples.models.ObjectExample;
import io.swagger.oas.inflector.models.ApiError;
import io.swagger.oas.inflector.models.RequestContext;
import io.swagger.oas.inflector.models.ResponseContext;
import io.swagger.oas.inflector.processors.EntityProcessor;
import io.swagger.oas.inflector.processors.EntityProcessorFactory;
import io.swagger.oas.inflector.schema.SchemaValidator;
import io.swagger.oas.inflector.utils.ApiErrorUtils;
import io.swagger.oas.inflector.utils.ApiException;
import io.swagger.oas.inflector.utils.ContentTypeSelector;
import io.swagger.oas.inflector.utils.ReflectionUtils;
import io.swagger.oas.inflector.validators.ValidationException;
import io.swagger.oas.inflector.validators.ValidationMessage;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.glassfish.jersey.process.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIOperationController
extends ReflectionUtils
implements Inflector<ContainerRequestContext, Response> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIOperationController.class);
    private static final String RANDOM_EXAMPLE = "random";
    private static final String SEQUENCIAL_EXAMPLE = "sequence";
    private int sequence = 0;
    private static Set<String> commonHeaders = new HashSet<String>();
    private String path;
    private String httpMethod;
    private Operation operation;
    private Object controller = null;
    private Method method = null;
    private JavaType[] parameterClasses = null;
    private JavaType[] requestBodyClasses = null;
    private Map<String, Schema> definitions;
    private InputConverter validator;
    private String controllerName;
    private String methodName;
    private String operationSignature;
    @Inject
    private Provider<Providers> providersProvider;
    @Inject
    private Provider<HttpServletRequest> requestProvider;
    private ControllerFactory controllerFactoryCache = null;

    public OpenAPIOperationController(Configuration config, String path, String httpMethod, Operation operation, Map<String, Schema> definitions) {
        this.setConfiguration(config);
        this.path = path;
        this.httpMethod = httpMethod;
        this.operation = operation;
        this.definitions = definitions;
        this.validator = InputConverter.getInstance();
        this.method = this.detectMethod(operation);
        if (this.method == null) {
            LOGGER.debug("no method `" + this.methodName + "` in `" + this.controllerName + "` to map to, using mock response");
        }
    }

    public Method detectMethod(Operation operation) {
        this.controllerName = this.getControllerName(operation);
        this.methodName = this.getMethodName(this.path, this.httpMethod, operation);
        JavaType[] args = this.getOperationParameterClasses(operation, this.definitions);
        JavaType[] args2 = this.getOperationRequestBodyClasses(operation, this.definitions);
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMethodName(this.path, this.httpMethod, operation)).append("(");
        for (int i = 0; i < args.length; ++i) {
            if (i == 0) {
                builder.append(RequestContext.class.getCanonicalName()).append(" request");
                continue;
            }
            builder.append(", ");
            if (args[i] == null) {
                LOGGER.error("didn't expect a null class for the argument in operation " + operation.getOperationId());
                continue;
            }
            if (args[i].getRawClass() == null) continue;
            String className = args[i].getRawClass().getName();
            if (className.startsWith("java.lang.")) {
                className = className.substring("java.lang.".length());
            }
            builder.append(className);
            builder.append(" ").append(args[1]);
        }
        builder.append(")");
        this.operationSignature = "public ResponseContext " + builder.toString();
        LOGGER.info("looking for method: `" + this.operationSignature + "` in class `" + this.controllerName + "`");
        this.parameterClasses = args;
        this.requestBodyClasses = args2;
        if (this.controllerName != null && this.methodName != null) {
            try {
                Method[] methods;
                Class<?> cls;
                try {
                    cls = Class.forName(this.controllerName);
                }
                catch (ClassNotFoundException e) {
                    this.controllerName = this.controllerName + "Controller";
                    cls = Class.forName(this.controllerName);
                }
                for (Method method : methods = cls.getMethods()) {
                    Class<?>[] methodArgs;
                    if (!this.methodName.equals(method.getName()) || (methodArgs = method.getParameterTypes()).length != args.length) continue;
                    int i = 0;
                    boolean matched = true;
                    if (!args[i].getRawClass().equals(methodArgs[i])) {
                        LOGGER.debug("failed to match " + args[i] + ", " + methodArgs[i]);
                        matched = false;
                    }
                    if (!matched) continue;
                    this.parameterClasses = args;
                    this.requestBodyClasses = args2;
                    this.controller = this.getControllerFactory().instantiateController(cls, operation);
                    LOGGER.debug("found class `" + this.controllerName + "`");
                    return method;
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug("didn't find class " + this.controller);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response apply(ContainerRequestContext ctx) {
        block145: {
            block146: {
                block143: {
                    block144: {
                        block142: {
                            block137: {
                                block136: {
                                    block141: {
                                        block133: {
                                            block132: {
                                                block131: {
                                                    block138: {
                                                        parameters = this.operation.getParameters();
                                                        requestBody = 0;
                                                        if (this.operation.getRequestBody() != null) {
                                                            requestBody = this.requestBodyClasses.length - 1;
                                                        }
                                                        argumentsSize = parameters.size() + requestBody;
                                                        requestContext = this.createContext(ctx);
                                                        formMap = new HashMap<String, Map<String, String>>();
                                                        inputStreams = new HashMap<String, File>();
                                                        formDataString = null;
                                                        parts = null;
                                                        args = new Object[argumentsSize + 1];
                                                        i = 0;
                                                        args[i] = requestContext;
                                                        ++i;
                                                        missingParams = new ArrayList<ValidationMessage>();
                                                        uri = ctx.getUriInfo();
                                                        existingKeys = new HashSet<String>();
                                                        x = uri.getQueryParameters().keySet().iterator();
                                                        while (x.hasNext()) {
                                                            existingKeys.add((String)x.next() + ": qp");
                                                        }
                                                        x = uri.getPathParameters().keySet().iterator();
                                                        while (x.hasNext()) {
                                                            existingKeys.add((String)x.next() + ": pp");
                                                        }
                                                        mt = requestContext.getMediaType();
                                                        argument = null;
                                                        if (this.operation.getRequestBody() == null) break block133;
                                                        body = this.operation.getRequestBody();
                                                        headers = new HashMap<String, String>();
                                                        name = null;
                                                        if (!ctx.hasEntity()) break block138;
                                                        jt = this.requestBodyClasses[i];
                                                        cls = null;
                                                        if (jt != null) {
                                                            cls = jt.getRawClass();
                                                        }
                                                        try {
                                                            argument = EntityProcessorFactory.readValue(ctx.getMediaType(), ctx.getEntityStream(), cls);
                                                            if (argument != null) {
                                                                if (body.getContent() != null) {
                                                                    content = body.getContent();
                                                                    for (String key : content.keySet()) {
                                                                        mediaType = (MediaType)content.get((Object)key);
                                                                        if (mediaType.getSchema() == null) continue;
                                                                        this.validate(argument, mediaType.getSchema(), SchemaValidator.Direction.INPUT);
                                                                    }
                                                                }
                                                                if (parameters != null && parameters.size() != 0) ** GOTO lbl238
                                                                args[i] = argument;
                                                                ++i;
                                                            }
                                                            if (body.getContent() == null) ** GOTO lbl238
lbl54:
                                                            // 8 sources

                                                            for (String mediaType : body.getContent().keySet()) {
                                                                block140: {
                                                                    block139: {
                                                                        if (formDataString != null || mt == null) continue;
                                                                        if (!mt.isCompatible(javax.ws.rs.core.MediaType.MULTIPART_FORM_DATA_TYPE)) break block139;
                                                                        boundary = (String[])mt.getParameters().get("boundary");
                                                                        if (boundary == null) break block140;
                                                                        try {
                                                                            inputStream = ctx.getEntityStream();
                                                                            multipartStream = new MultipartStream(inputStream, boundary.getBytes());
                                                                            nextPart = multipartStream.skipPreamble();
                                                                            block40: while (nextPart) {
                                                                                header = multipartStream.readHeaders();
                                                                                if (header == null) ** GOTO lbl74
                                                                                format = CSVFormat.DEFAULT.withDelimiter(';').withRecordSeparator("=");
                                                                                var30_61 = format.parse((Reader)new StringReader(header));
                                                                                var31_74 = var30_61.iterator();
                                                                                while (true) {
                                                                                    if (var31_74.hasNext()) {
                                                                                        var32_83 = (CSVRecord)var31_74.next();
                                                                                        j = 0;
                                                                                        break block131;
                                                                                    }
lbl74:
                                                                                    // 3 sources

                                                                                    if ((filename = OpenAPIOperationController.extractFilenameFromHeaders(headers)) != null) {
                                                                                        try {
                                                                                            var30_62 = new File(Files.createTempDir(), filename);
                                                                                            var30_62.deleteOnExit();
                                                                                            var30_62.getParentFile().deleteOnExit();
                                                                                            fo = new FileOutputStream(var30_62);
                                                                                            multipartStream.readBodyData((OutputStream)fo);
                                                                                            inputStreams.put(name, var30_62);
                                                                                        }
                                                                                        catch (Exception var30_63) {
                                                                                            OpenAPIOperationController.LOGGER.error("Failed to extract uploaded file", (Throwable)var30_63);
                                                                                        }
                                                                                    } else {
                                                                                        var30_64 = new ByteArrayOutputStream();
                                                                                        multipartStream.readBodyData((OutputStream)var30_64);
                                                                                        value = var30_64.toString();
                                                                                        headers.put(name, value);
                                                                                    }
                                                                                    if (name != null) {
                                                                                        formMap.put(name, headers);
                                                                                    }
                                                                                    headers = new HashMap<K, V>();
                                                                                    name = null;
                                                                                    nextPart = multipartStream.readBoundary();
                                                                                    continue block40;
                                                                                    break;
                                                                                }
                                                                            }
                                                                        }
                                                                        catch (IOException e) {
                                                                            e.printStackTrace();
                                                                        }
                                                                        break block140;
                                                                    }
                                                                    try {
                                                                        formDataString = IOUtils.toString((InputStream)ctx.getEntityStream(), (String)"UTF-8");
                                                                        for (String part : parts = formDataString.split("&")) {
                                                                            kv = part.split("=");
                                                                            existingKeys.add(kv[0] + ": fp");
                                                                        }
                                                                    }
                                                                    catch (IOException e) {
                                                                        e.printStackTrace();
                                                                    }
                                                                }
                                                                try {
                                                                    media = (MediaType)body.getContent().get((Object)mediaType);
                                                                    if (media.getSchema() == null) continue;
                                                                    schema = media.getSchema();
                                                                    if (mt.isCompatible(javax.ws.rs.core.MediaType.MULTIPART_FORM_DATA_TYPE)) {
                                                                        if (schema.getProperties() == null) continue;
                                                                        properties = schema.getProperties();
                                                                        part = properties.keySet().iterator();
                                                                        break block132;
                                                                    }
                                                                    if (formDataString == null || schema.getProperties() == null) continue;
                                                                    properties = schema.getProperties();
                                                                    for (String property : properties.keySet()) {
                                                                        for (String var32_84 : parts) {
                                                                            kv = var32_84.split("=");
                                                                            if (kv == null) continue;
                                                                            if (kv.length > 0) {
                                                                                existingKeys.remove(kv[0] + ": fp");
                                                                            }
                                                                            if (kv.length != 2) continue;
                                                                            key = kv[0];
                                                                            try {
                                                                                value = URLDecoder.decode(kv[1], "utf-8");
                                                                                if (!property.equals(key)) continue;
                                                                                jt = this.requestBodyClasses[i];
                                                                                cls = jt.getRawClass();
                                                                                try {
                                                                                    args[i] = argument = this.validator.convertAndValidate(Arrays.asList(new String[]{value}), body, cls, this.definitions);
                                                                                    argument = null;
                                                                                    ++i;
                                                                                }
                                                                                catch (ConversionException e) {
                                                                                    missingParams.add(e.getError());
                                                                                }
                                                                                catch (ValidationException e) {
                                                                                    missingParams.add(e.getValidationMessage());
                                                                                }
                                                                            }
                                                                            catch (UnsupportedEncodingException e) {
                                                                                OpenAPIOperationController.LOGGER.error("unable to decode value for " + key);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                catch (NumberFormatException e) {
                                                                    OpenAPIOperationController.LOGGER.error("Couldn't find body ( ) to " + this.parameterClasses[i], (Throwable)e);
                                                                }
                                                            }
                                                        }
                                                        catch (ConversionException e) {
                                                            missingParams.add(e.getError());
                                                        }
                                                        break block133;
                                                    }
                                                    if (this.operation.getRequestBody().getRequired().booleanValue()) {
                                                        e = new ValidationException();
                                                        e.message(new ValidationMessage().message("The input body `" + this.operation.getRequestBody() + "` is required"));
                                                        try {
                                                            throw e;
                                                        }
                                                        catch (ValidationException e1) {
                                                            missingParams.add(e.getValidationMessage());
                                                            break block133;
                                                        }
                                                    }
                                                    break block133;
                                                }
                                                while (true) {
                                                    if (j >= var32_83.size()) ** continue;
                                                    string = var32_83.get(j);
                                                    outerString = CSVFormat.DEFAULT.withDelimiter('=').parse((Reader)new StringReader(string));
                                                    for (CSVRecord outerKvPair : outerString) {
                                                        if (outerKvPair.size() == 2) {
                                                            key = outerKvPair.get(0).trim();
                                                            value = outerKvPair.get(1).trim();
                                                            if ("name".equals(key)) {
                                                                name = value;
                                                            }
                                                            headers.put(key, value);
                                                            continue;
                                                        }
                                                        innerString = CSVFormat.DEFAULT.withDelimiter(':').parse((Reader)new StringReader(string));
                                                        for (CSVRecord innerKVPair : innerString) {
                                                            if (innerKVPair.size() != 2) continue;
                                                            key = innerKVPair.get(0).trim();
                                                            value = innerKVPair.get(1).trim();
                                                            if ("name".equals(key)) {
                                                                name = value;
                                                            }
                                                            headers.put(key, value);
                                                        }
                                                    }
                                                    if (name != null) {
                                                        formMap.put(name, headers);
                                                    }
                                                    ++j;
                                                }
                                            }
                                            while (part.hasNext()) {
                                                key = (String)part.next();
                                                headers = (Map)formMap.get(key);
                                                if (headers != null && headers.size() > 0) {
                                                    if ("binary".equals(((Schema)properties.get(key)).getFormat())) {
                                                        argument = inputStreams.get(key);
                                                    } else {
                                                        obj = headers.get(key);
                                                        if (obj != null) {
                                                            jt = this.requestBodyClasses[i];
                                                            cls = jt.getRawClass();
                                                            var30_66 = Arrays.asList(new String[]{obj.toString()});
                                                            try {
                                                                argument = this.validator.convertAndValidate(var30_66, body, cls, this.definitions);
                                                            }
                                                            catch (ConversionException e) {
                                                                missingParams.add(e.getError());
                                                            }
                                                            catch (ValidationException e) {
                                                                missingParams.add(e.getValidationMessage());
                                                            }
                                                        }
                                                    }
                                                }
                                                args[i] = argument;
                                                argument = null;
                                                ++i;
                                            }
                                            ** GOTO lbl54
                                        }
                                        if (parameters == null || parameters.size() <= 0) break block141;
                                        for (Parameter parameter : parameters) {
                                            block134: {
                                                in = parameter.getIn();
                                                try {
                                                    try {
                                                        paramName = parameter.getName();
                                                        if ("query".equals(in)) {
                                                            existingKeys.remove(paramName + ": qp");
                                                        }
                                                        if ("path".equals(in)) {
                                                            existingKeys.remove(paramName + ": pp");
                                                        }
                                                        jt = this.parameterClasses[i];
                                                        cls = jt.getRawClass();
                                                        if ("query".equals(in)) {
                                                            argument = this.validator.convertAndValidate((List<String>)((List)uri.getQueryParameters().get((Object)parameter.getName())), parameter, cls, this.definitions);
                                                            break block134;
                                                        }
                                                        if ("path".equals(in)) {
                                                            argument = this.validator.convertAndValidate((List<String>)((List)uri.getPathParameters().get((Object)parameter.getName())), parameter, cls, this.definitions);
                                                        } else if ("header".equals(in)) {
                                                            argument = this.validator.convertAndValidate((List<String>)((List)ctx.getHeaders().get((Object)parameter.getName())), parameter, cls, this.definitions);
                                                        }
                                                    }
                                                    catch (ConversionException e) {
                                                        missingParams.add(e.getError());
                                                    }
                                                    catch (ValidationException e) {
                                                        missingParams.add(e.getValidationMessage());
                                                    }
                                                }
                                                catch (NumberFormatException e) {
                                                    OpenAPIOperationController.LOGGER.error("Couldn't find " + parameter.getName() + " (" + (String)in + ") to " + this.parameterClasses[i], (Throwable)e);
                                                }
                                            }
                                            args[i] = argument;
                                            ++i;
                                        }
                                        if (existingKeys.size() > 0) {
                                            OpenAPIOperationController.LOGGER.debug("unexpected keys: " + existingKeys);
                                        }
                                        if (missingParams.size() <= 0) break block141;
                                        builder = new StringBuilder();
                                        builder.append("Input error");
                                        if (missingParams.size() > 1) {
                                            builder.append("s");
                                        }
                                        builder.append(": ");
                                        count = 0;
                                        in = missingParams.iterator();
                                        ** GOTO lbl337
                                    }
                                    if (this.method != null) {
                                        block135: {
                                            OpenAPIOperationController.LOGGER.info("calling method " + this.method + " on controller " + this.controller + " with args " + Arrays.toString(args));
                                            try {
                                                response = this.method.invoke(this.controller, args);
                                                if (!(response instanceof ResponseContext)) break block135;
                                                wrapper = (ResponseContext)response;
                                                builder = Response.status((int)wrapper.getStatus());
                                                error = wrapper.getHeaders().keySet().iterator();
                                                break block136;
                                            }
                                            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                                                cause = e.getCause();
                                                while (cause != null) {
                                                    if (cause instanceof ApiException) {
                                                        throw (ApiException)cause;
                                                    }
                                                    next = cause.getCause();
                                                    cause = next == cause || next == null ? null : next;
                                                }
                                                throw new ApiException(ApiErrorUtils.createInternalError(), (Throwable)e);
                                            }
                                        }
                                        wrapper = Response.ok().entity(response).build();
                                        return wrapper;
                                    }
                                    responses = this.operation.getResponses();
                                    if (responses != null) {
                                        keys = new String[responses.keySet().size()];
                                        Arrays.sort(responses.keySet().toArray(keys));
                                        code = 0;
                                        defaultKey = null;
                                        file = keys;
                                        key = file.length;
                                        break block137;
                                    } else {
                                        var18_19 = Response.ok().build();
                                        return var18_19;
                                    }
                                    finally {
                                        responseSchema = inputStreams.keySet().iterator();
                                        while (true) {
                                            if (!responseSchema.hasNext()) {
                                            }
                                            key = (String)responseSchema.next();
                                            file = (File)inputStreams.get(key);
                                            if (file == null) continue;
                                            OpenAPIOperationController.LOGGER.debug("deleting file " + file.getPath());
                                            file.delete();
                                        }
                                    }
lbl337:
                                    // 1 sources

                                    while (true) {
                                        if (!in.hasNext()) {
                                            statusCode = this.config.getInvalidRequestStatusCode();
                                            error = new ApiError().code(statusCode).message(builder.toString());
                                            throw new ApiException((ApiError)error);
                                        }
                                        message = (ValidationMessage)in.next();
                                        if (count > 0) {
                                            builder.append(", ");
                                        }
                                        if (message != null && message.getMessage() != null) {
                                            builder.append(message.getMessage());
                                        } else {
                                            builder.append("no additional input");
                                        }
                                        ++count;
                                    }
                                }
                                while (error.hasNext()) {
                                    key = (String)error.next();
                                    v = (List)wrapper.getHeaders().get((Object)key);
                                    if (v.size() == 1) {
                                        builder.header(key, v.get(0));
                                        continue;
                                    }
                                    builder.header(key, (Object)v);
                                }
                                if (wrapper.getEntity() != null) {
                                    builder.entity(wrapper.getEntity());
                                    if (wrapper.getContentType() != null) {
                                        builder.type(wrapper.getContentType());
                                    } else {
                                        selector = ((Providers)this.providersProvider.get()).getContextResolver(ContentTypeSelector.class, javax.ws.rs.core.MediaType.WILDCARD_TYPE);
                                        if (selector != null) {
                                            ((ContentTypeSelector)selector.getContext(this.getClass())).apply(ctx.getAcceptableMediaTypes(), builder);
                                        }
                                    }
                                    if (this.operation.getResponses() != null) {
                                        responseCode /* !! */  = String.valueOf(wrapper.getStatus());
                                        responseSchema = (ApiResponse)this.operation.getResponses().get((Object)responseCode /* !! */ );
                                        if (responseSchema == null) {
                                            responseSchema = (ApiResponse)this.operation.getResponses().get((Object)"default");
                                        }
                                        if (responseSchema != null) {
                                            if (responseSchema.getContent() != null) {
                                                for (String name : responseSchema.getContent().keySet()) {
                                                    if (((MediaType)responseSchema.getContent().get((Object)name)).getSchema() == null) continue;
                                                    this.validate(wrapper.getEntity(), ((MediaType)responseSchema.getContent().get((Object)name)).getSchema(), SchemaValidator.Direction.OUTPUT);
                                                }
                                            }
                                        } else {
                                            OpenAPIOperationController.LOGGER.debug("no response schema for code " + (String)responseCode /* !! */  + " to validate against");
                                        }
                                    }
                                }
                                responseCode /* !! */  = builder.build();
                                return responseCode /* !! */ ;
                            }
                            for (file = 0; file < key; ++file) {
                                key = file[file];
                                if (key.startsWith("2")) {
                                    defaultKey = key;
                                    code = Integer.parseInt(key);
                                    break;
                                }
                                if ("default".equals(key)) {
                                    defaultKey = key;
                                    code = 200;
                                    break;
                                }
                                if (!key.startsWith("3")) continue;
                                defaultKey = key;
                                code = Integer.parseInt(key);
                            }
                            if (defaultKey == null) break block142;
                            builder = Response.status((int)code);
                            response = (ApiResponse)responses.get(defaultKey);
                            if (response.getHeaders() == null || response.getHeaders().size() <= 0) break block143;
                            property = null;
                            output = null;
                            schema = response.getHeaders().keySet().iterator();
                            break block144;
                        }
                        OpenAPIOperationController.LOGGER.debug("no response type to map to, assume 200");
                        code = 200;
                        builder = Response.status((int)code).build();
                        return builder;
                    }
                    while (schema.hasNext()) {
                        key = (String)schema.next();
                        headerProperty = (Header)response.getHeaders().get(key);
                        if (headerProperty.getSchema() == null) continue;
                        output = ExampleBuilder.fromSchema(headerProperty.getSchema(), this.definitions);
                        if (output instanceof ArrayExample) {
                            output = ((ArrayExample)output).asString();
                        } else if (output instanceof ObjectExample) {
                            OpenAPIOperationController.LOGGER.debug("not serializing output example, only primitives or arrays of primitives are supported");
                        } else {
                            output = ((io.swagger.oas.inflector.examples.models.Example)output).asString();
                        }
                        builder.header(key, output);
                    }
                }
                examples = new HashMap<K, V>();
                output = null;
                exampleProcessorList = this.config.getExampleProcessors();
                outputExample = null;
                if (response.getContent() == null) break block145;
                if (requestContext.getHeaders().get((Object)"Accept") == null) break block146;
                for (String acceptable : (List)requestContext.getHeaders().get((Object)"Accept")) {
                    block148: {
                        block149: {
                            block147: {
                                if (response.getContent().get((Object)acceptable) == null) break block147;
                                if (((MediaType)response.getContent().get((Object)acceptable)).getExamples() != null) {
                                    examples = ((MediaType)response.getContent().get((Object)acceptable)).getExamples();
                                }
                                if (examples == null || examples.size() <= 0) break block148;
                                obj = requestContext.getAcceptableMediaTypes().iterator();
                                break block149;
                            }
                            obj = response.getContent().keySet().iterator();
                            if (!obj.hasNext()) continue;
                            var30_69 = (String)obj.next();
                            output = ExampleBuilder.fromSchema(((MediaType)response.getContent().get((Object)var30_69)).getSchema(), this.definitions);
                            continue;
                        }
                        while (obj.hasNext()) {
                            var30_68 = (javax.ws.rs.core.MediaType)obj.next();
                            media = javax.ws.rs.core.MediaType.valueOf((String)acceptable);
                            if (!media.isCompatible(var30_68) || exampleProcessorList == null || exampleProcessorList.size() <= 0 || !(var32_86 = exampleProcessorList.iterator()).hasNext()) continue;
                            mode = var32_86.next();
                            if (mode.equals("random")) {
                                generator = new Random();
                                values = examples.values().toArray();
                                outputExample = (Example)values[generator.nextInt(values.length)];
                            } else if (mode.equals("sequence")) {
                                if (this.sequence >= examples.size()) {
                                    this.sequence = 0;
                                }
                                values = examples.values().toArray();
                                outputExample = (Example)values[this.sequence];
                                ++this.sequence;
                            }
                            builder.entity(outputExample).type(acceptable);
                            values = builder.build();
                            return values;
                        }
                    }
                    output = ExampleBuilder.fromSchema(((MediaType)response.getContent().get((Object)acceptable)).getSchema(), this.definitions);
                }
                break block145;
            }
            for (String key : response.getContent().keySet()) {
                if (((MediaType)response.getContent().get((Object)key)).getExamples() != null) {
                    examples = ((MediaType)response.getContent().get((Object)key)).getExamples();
                }
                if (examples != null && examples.size() > 0) {
                    for (javax.ws.rs.core.MediaType var30_70 : requestContext.getAcceptableMediaTypes()) {
                        if (!javax.ws.rs.core.MediaType.valueOf((String)key).isCompatible(var30_70) || exampleProcessorList == null || exampleProcessorList.size() <= 0 || !(media = exampleProcessorList.iterator()).hasNext()) continue;
                        var32_87 = media.next();
                        if (var32_87.equals("random")) {
                            generator = new Random();
                            values = examples.values().toArray();
                            outputExample = (Example)values[generator.nextInt(((Object[])values).length)];
                        } else if (var32_87.equals("sequence")) {
                            if (this.sequence >= examples.size()) {
                                this.sequence = 0;
                            }
                            values = examples.values().toArray();
                            outputExample = (Example)values[this.sequence];
                            ++this.sequence;
                        }
                        builder.entity(outputExample).type(javax.ws.rs.core.MediaType.valueOf((String)key));
                        values = builder.build();
                        return values;
                    }
                }
                output = ExampleBuilder.fromSchema(((MediaType)response.getContent().get((Object)key)).getSchema(), this.definitions);
            }
        }
        if (output != null) {
            resp = new ResponseContext().entity(output);
            this.setContentType(requestContext, resp, this.operation);
            builder.entity(output);
            if (resp.getContentType() != null) {
                builder.type(resp.getContentType());
            } else {
                processors = EntityProcessorFactory.getProcessors();
                responseMediaType = null;
                block61: for (EntityProcessor processor : processors) {
                    if (responseMediaType != null) break;
                    for (javax.ws.rs.core.MediaType mediaTypet : requestContext.getAcceptableMediaTypes()) {
                        OpenAPIOperationController.LOGGER.debug("checking type " + mt.toString() + " against " + processor.getClass().getName());
                        if (!processor.supports(mt)) continue;
                        builder.type(mediaTypet);
                        responseMediaType = mediaTypet;
                        continue block61;
                    }
                }
                if (responseMediaType == null) {
                    for (EntityProcessor processor : processors) {
                        var32_91 = processor.getSupportedMediaTypes();
                        if (var32_91.size() <= 0) continue;
                        builder.type(var32_91.get(0));
                        break;
                    }
                }
            }
            builder.entity(output);
        }
        var27_58 = builder.build();
        return var27_58;
    }

    static String extractFilenameFromHeaders(Map<String, String> headers) {
        String filename = headers.get("filename");
        if (StringUtils.isBlank((String)filename)) {
            return null;
        }
        int ix = (filename = filename.trim()).lastIndexOf(File.separatorChar);
        if (ix != -1 && StringUtils.isBlank((String)(filename = filename.substring(ix + 1).trim()))) {
            return null;
        }
        return filename;
    }

    public void validate(Object o, Schema property, SchemaValidator.Direction direction) throws ApiException {
        this.doValidation(o, property, direction);
    }

    public void setContentType(RequestContext res, ResponseContext resp, Operation operation) {
        if (resp.getContentType() != null) {
            return;
        }
        ApiResponses responses = operation.getResponses();
        if (responses != null) {
            for (String responseCode : responses.keySet()) {
                ApiResponse response = (ApiResponse)responses.get((Object)responseCode);
                Content content = response.getContent();
                if (content == null) {
                    return;
                }
                for (String key : content.keySet()) {
                    javax.ws.rs.core.MediaType mediaType = javax.ws.rs.core.MediaType.valueOf((String)key);
                    if (res.getHeaders().get((Object)"Accept") != null) {
                        for (String string : (List)res.getHeaders().get((Object)"Accept")) {
                            String subtype = string.substring(string.lastIndexOf("/") + 1);
                            resp.setContentType(mediaType);
                            if (!subtype.equals(mediaType.getSubtype())) continue;
                            return;
                        }
                        continue;
                    }
                    for (javax.ws.rs.core.MediaType mediaType2 : res.getAcceptableMediaTypes()) {
                        resp.setContentType(mediaType);
                        if (!mediaType.isCompatible(mediaType2)) continue;
                        return;
                    }
                }
            }
        }
    }

    public String getOperationSignature() {
        return this.operationSignature;
    }

    public void setOperationSignature(String operationSignature) {
        this.operationSignature = operationSignature;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public void setControllerName(String controllerName) {
        this.controllerName = controllerName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    private RequestContext createContext(ContainerRequestContext from) {
        HttpServletRequest request;
        RequestContext result = new RequestContext(from);
        if (this.requestProvider != null && (request = (HttpServletRequest)this.requestProvider.get()) != null) {
            result.setRemoteAddr(request.getRemoteAddr());
        }
        return result;
    }

    private void doValidation(Object value, Object schema, SchemaValidator.Direction direction) throws ApiException {
        if (this.config.getValidatePayloads().isEmpty()) {
            return;
        }
        switch (direction) {
            case INPUT: {
                if (!this.config.getValidatePayloads().contains((Object)Configuration.Direction.IN) || SchemaValidator.validate(value, Json.pretty((Object)schema), direction)) break;
                throw new ApiException(new ApiError().code(this.config.getInvalidRequestStatusCode()).message("Input does not match the expected structure"));
            }
            case OUTPUT: {
                if (!this.config.getValidatePayloads().contains((Object)Configuration.Direction.OUT) || SchemaValidator.validate(value, Json.pretty((Object)schema), direction)) break;
                throw new ApiException(new ApiError().code(this.config.getInvalidRequestStatusCode()).message("The server generated an invalid response"));
            }
        }
    }

    private ControllerFactory getControllerFactory() {
        if (this.controllerFactoryCache == null) {
            this.controllerFactoryCache = this.config.getControllerFactory();
        }
        return this.controllerFactoryCache;
    }

    static {
        commonHeaders.add("Host");
        commonHeaders.add("User-Agent");
        commonHeaders.add("Accept");
        commonHeaders.add("Content-Type");
        commonHeaders.add("Content-Length");
    }
}

