/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.examples;

import io.swagger.oas.inflector.examples.models.ArrayExample;
import io.swagger.oas.inflector.examples.models.BooleanExample;
import io.swagger.oas.inflector.examples.models.DecimalExample;
import io.swagger.oas.inflector.examples.models.DoubleExample;
import io.swagger.oas.inflector.examples.models.Example;
import io.swagger.oas.inflector.examples.models.FloatExample;
import io.swagger.oas.inflector.examples.models.IntegerExample;
import io.swagger.oas.inflector.examples.models.LongExample;
import io.swagger.oas.inflector.examples.models.ObjectExample;
import io.swagger.oas.inflector.examples.models.StringExample;
import io.swagger.util.Json;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import io.swagger.v3.oas.models.media.XML;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExampleBuilder.class);
    public static final String SAMPLE_EMAIL_PROPERTY_VALUE = "apiteam@swagger.io";
    public static final String SAMPLE_UUID_PROPERTY_VALUE = "3fa85f64-5717-4562-b3fc-2c963f66afa6";
    public static final String SAMPLE_STRING_PROPERTY_VALUE = "string";
    public static final int SAMPLE_INT_PROPERTY_VALUE = 0;
    public static final int SAMPLE_LONG_PROPERTY_VALUE = 0;
    public static final int SAMPLE_BASE_INTEGER_PROPERTY_VALUE = 0;
    public static final float SAMPLE_FLOAT_PROPERTY_VALUE = 1.1f;
    public static final double SAMPLE_DOUBLE_PROPERTY_VALUE = (double)1.1f;
    public static final boolean SAMPLE_BOOLEAN_PROPERTY_VALUE = true;
    public static final String SAMPLE_DATE_PROPERTY_VALUE = "2015-07-20";
    public static final String SAMPLE_DATETIME_PROPERTY_VALUE = "2015-07-20T15:49:04-07:00";
    public static final double SAMPLE_DECIMAL_PROPERTY_VALUE = 1.5;

    public static Example fromSchema(Schema property, Map<String, Schema> definitions) {
        return ExampleBuilder.fromProperty(null, property, definitions, new HashSet<String>(), null);
    }

    public static Example fromSchema(Schema property, Map<String, Schema> definitions, RequestType requestType) {
        return ExampleBuilder.fromProperty(null, property, definitions, new HashSet<String>(), requestType);
    }

    public static Example fromProperty(String name, Schema property, Map<String, Schema> definitions, Set<String> processedModels, RequestType requestType) {
        Example innerExample;
        Schema inner;
        Schema inner2;
        List enums;
        List enums2;
        Object defaultValue;
        if (property == null) {
            return null;
        }
        if (property.getReadOnly() != null && property.getReadOnly().booleanValue() && requestType == RequestType.WRITE) {
            return null;
        }
        if (property.getWriteOnly() != null && property.getWriteOnly().booleanValue() && requestType == RequestType.READ) {
            return null;
        }
        String namespace = null;
        String prefix = null;
        Boolean attribute = false;
        Boolean wrapped = false;
        if (property.getXml() != null) {
            XML xml = property.getXml();
            name = xml.getName();
            namespace = xml.getNamespace();
            prefix = xml.getPrefix();
            attribute = xml.getAttribute();
            wrapped = xml.getWrapped() != null ? xml.getWrapped() : false;
        }
        Object output = null;
        Object example = property.getExample();
        if (property.get$ref() != null) {
            Schema model;
            String ref = property.get$ref();
            if (processedModels.contains(ref = ref.substring(ref.lastIndexOf("/") + 1))) {
                return ExampleBuilder.alreadyProcessedRefExample(ref, definitions);
            }
            processedModels.add(ref);
            if (definitions != null && (model = definitions.get(ref)) != null) {
                output = ExampleBuilder.fromProperty(ref, model, definitions, processedModels, requestType);
                return output;
            }
        } else if (property instanceof EmailSchema) {
            if (example != null) {
                output = new StringExample(example.toString());
            } else {
                defaultValue = (String)((EmailSchema)property).getDefault();
                if (defaultValue == null && (enums2 = ((EmailSchema)property).getEnum()) != null && !enums2.isEmpty()) {
                    defaultValue = (String)enums2.get(0);
                }
                output = new StringExample((String)(defaultValue == null ? SAMPLE_EMAIL_PROPERTY_VALUE : defaultValue));
            }
        } else if (property instanceof UUIDSchema) {
            if (example != null) {
                output = new StringExample(example.toString());
            } else {
                defaultValue = (UUID)((UUIDSchema)property).getDefault();
                if (defaultValue == null && (enums2 = ((UUIDSchema)property).getEnum()) != null && !enums2.isEmpty()) {
                    defaultValue = (UUID)enums2.get(0);
                }
                output = new StringExample(defaultValue == null ? SAMPLE_UUID_PROPERTY_VALUE : ((UUID)defaultValue).toString());
            }
        } else if (property instanceof StringSchema) {
            if (example != null) {
                output = new StringExample(example.toString());
            } else {
                defaultValue = (String)((StringSchema)property).getDefault();
                if (defaultValue == null && (enums2 = ((StringSchema)property).getEnum()) != null && !enums2.isEmpty()) {
                    defaultValue = (String)enums2.get(0);
                }
                output = new StringExample((String)(defaultValue == null ? SAMPLE_STRING_PROPERTY_VALUE : defaultValue));
            }
        } else if (property instanceof IntegerSchema) {
            if (example != null) {
                try {
                    if (property.getFormat() != null) {
                        if (property.getFormat().equals("int32")) {
                            output = new IntegerExample(Integer.parseInt(example.toString()));
                        } else if (property.getFormat().equals("int64")) {
                            output = new LongExample(Long.parseLong(example.toString()));
                        }
                    } else {
                        output = new IntegerExample(Integer.parseInt(example.toString()));
                    }
                }
                catch (NumberFormatException defaultValue2) {
                    // empty catch block
                }
            }
            if (output == null) {
                defaultValue = (Number)((IntegerSchema)property).getDefault();
                if (defaultValue == null && (enums2 = ((IntegerSchema)property).getEnum()) != null && !enums2.isEmpty()) {
                    defaultValue = (Number)enums2.get(0);
                }
                if (property.getFormat() != null) {
                    if (property.getFormat().equals("int32")) {
                        output = new IntegerExample(defaultValue == null ? 0 : ((Number)defaultValue).intValue());
                    } else if (property.getFormat().equals("int64")) {
                        output = new LongExample(defaultValue == null ? 0L : ((Number)defaultValue).longValue());
                    }
                } else {
                    output = new IntegerExample(0);
                }
            }
        } else if (property instanceof NumberSchema) {
            if (example != null) {
                try {
                    if (property.getFormat() != null) {
                        if (property.getFormat().equals("double")) {
                            output = new DoubleExample(Double.parseDouble(example.toString()));
                        } else if (property.getFormat().equals("float")) {
                            output = new FloatExample(Float.parseFloat(example.toString()));
                        }
                    } else {
                        output = new DecimalExample(new BigDecimal(example.toString()));
                    }
                }
                catch (NumberFormatException defaultValue3) {
                    // empty catch block
                }
            }
            if (output == null) {
                defaultValue = (BigDecimal)((NumberSchema)property).getDefault();
                if (defaultValue == null && (enums2 = ((NumberSchema)property).getEnum()) != null && !enums2.isEmpty()) {
                    defaultValue = (BigDecimal)enums2.get(0);
                }
                if (property.getFormat() != null) {
                    if (property.getFormat().equals("double")) {
                        output = new DoubleExample(defaultValue == null ? (double)1.1f : ((BigDecimal)defaultValue).doubleValue());
                    }
                    if (property.getFormat().equals("float")) {
                        output = new FloatExample(defaultValue == null ? 1.1f : ((BigDecimal)defaultValue).floatValue());
                    }
                } else {
                    output = new DecimalExample(new BigDecimal(1.5));
                }
            }
        } else if (property instanceof BooleanSchema) {
            output = example != null ? new BooleanExample(Boolean.valueOf(example.toString())) : new BooleanExample((defaultValue = (Boolean)property.getDefault()) == null ? true : (Boolean)defaultValue);
        } else if (property instanceof DateSchema) {
            output = example != null ? new StringExample(example.toString()) : ((enums = ((DateSchema)property).getEnum()) != null && !enums.isEmpty() ? new StringExample(((Date)enums.get(0)).toString()) : new StringExample(SAMPLE_DATE_PROPERTY_VALUE));
        } else if (property instanceof DateTimeSchema) {
            output = example != null ? new StringExample(example.toString()) : ((enums = ((DateTimeSchema)property).getEnum()) != null && !enums.isEmpty() ? new StringExample(((Date)enums.get(0)).toString()) : new StringExample(SAMPLE_DATETIME_PROPERTY_VALUE));
        } else if (property instanceof ObjectSchema) {
            if (example != null) {
                try {
                    output = (Example)Json.mapper().readValue(example.toString(), ObjectExample.class);
                }
                catch (IOException e) {
                    LOGGER.error("unable to convert `" + example + "` to JsonNode");
                    output = new ObjectExample();
                }
            } else {
                ObjectExample outputExample = new ObjectExample();
                outputExample.setName(property.getName());
                ObjectSchema op = (ObjectSchema)property;
                if (op.getProperties() != null) {
                    for (String propertyname : op.getProperties().keySet()) {
                        inner2 = (Schema)op.getProperties().get(propertyname);
                        Example innerExample2 = ExampleBuilder.fromProperty(null, inner2, definitions, processedModels, requestType);
                        outputExample.put(propertyname, innerExample2);
                    }
                    output = outputExample;
                }
            }
        } else if (property instanceof ArraySchema) {
            if (example != null) {
                output = new ArrayExample();
            } else {
                Example innerExample3;
                ArraySchema ap = (ArraySchema)property;
                Schema inner3 = ap.getItems();
                if (inner3 != null && (innerExample3 = ExampleBuilder.fromProperty(null, inner3, definitions, processedModels, requestType)) != null && innerExample3 instanceof Example) {
                    ArrayExample an = new ArrayExample();
                    an.add(innerExample3);
                    an.setName(property.getName());
                    output = an;
                }
            }
        } else if (property instanceof ComposedSchema) {
            Example innerExample4;
            List models;
            ComposedSchema composedSchema = (ComposedSchema)property;
            if (composedSchema.getAllOf() != null) {
                models = composedSchema.getAllOf();
                Iterator<Object> ex = new ObjectExample();
                ArrayList<Example> innerExamples = new ArrayList<Example>();
                if (models != null) {
                    for (Schema im : models) {
                        Example innerExample5 = ExampleBuilder.fromProperty(null, im, definitions, processedModels, requestType);
                        if (innerExample5 == null) continue;
                        innerExamples.add(innerExample5);
                    }
                }
                ExampleBuilder.mergeTo(ex, innerExamples);
                output = ex;
            } else if (composedSchema.getAnyOf() != null) {
                models = composedSchema.getAnyOf();
                if (models != null) {
                    for (Schema im : models) {
                        innerExample4 = ExampleBuilder.fromProperty(null, im, definitions, processedModels, requestType);
                        if (innerExample4 == null) continue;
                        output = innerExample4;
                        break;
                    }
                }
            } else if (composedSchema.getOneOf() != null && (models = composedSchema.getOneOf()) != null) {
                for (Schema im : models) {
                    innerExample4 = ExampleBuilder.fromProperty(null, im, definitions, processedModels, requestType);
                    if (innerExample4 == null) continue;
                    output = innerExample4;
                    break;
                }
            }
        } else if (property.getProperties() != null && output == null) {
            if (example != null) {
                try {
                    output = (Example)Json.mapper().readValue(example.toString(), ObjectExample.class);
                }
                catch (IOException e) {
                    LOGGER.error("unable to convert `" + example + "` to JsonNode");
                    output = new ObjectExample();
                }
            } else {
                ObjectExample ex = new ObjectExample();
                if (property.getProperties() != null) {
                    Map properties = property.getProperties();
                    for (String propertyKey : properties.keySet()) {
                        inner2 = (Schema)properties.get(propertyKey);
                        Example propExample = ExampleBuilder.fromProperty(null, inner2, definitions, processedModels, requestType);
                        ex.put(propertyKey, propExample);
                    }
                }
                output = ex;
            }
        }
        if (property.getAdditionalProperties() != null && property.getAdditionalProperties() instanceof Schema && (inner = (Schema)property.getAdditionalProperties()) != null && (innerExample = ExampleBuilder.fromProperty(null, inner, definitions, processedModels, requestType)) != null) {
            if (innerExample instanceof Example) {
                ObjectExample on;
                Example in = innerExample;
                if (in.getName() == null) {
                    in.setName("value");
                }
                if (output != null) {
                    on = (ObjectExample)output;
                    on.put("additionalProperty", in);
                } else {
                    on = new ObjectExample();
                    StringExample value = new StringExample("key");
                    value.setName("key");
                    on.put("key", value);
                    on.put("additionalProperty", in);
                    output = on;
                }
            } else {
                ObjectExample outputMap = new ObjectExample();
                outputMap.put("key", new ObjectExample());
                output = outputMap;
            }
        }
        if (output != null) {
            if (attribute != null) {
                output.setAttribute(attribute);
            }
            if (wrapped != null && wrapped.booleanValue()) {
                if (name != null) {
                    output.setWrappedName(name);
                }
            } else if (name != null) {
                output.setName(name);
            }
            output.setNamespace(namespace);
            output.setPrefix(prefix);
            output.setWrapped(wrapped);
        }
        return output;
    }

    public static Example alreadyProcessedRefExample(String name, Map<String, Schema> definitions) {
        Schema model = definitions.get(name);
        if (model == null) {
            return null;
        }
        Example output = null;
        if (model instanceof Schema && model.getType() != null) {
            if ("object".equals(model.getType())) {
                return new ObjectExample();
            }
            if (SAMPLE_STRING_PROPERTY_VALUE.equals(model.getType())) {
                return new StringExample("");
            }
            if ("integer".equals(model.getType())) {
                return new IntegerExample(0);
            }
            if ("long".equals(model.getType())) {
                return new LongExample(0L);
            }
            if ("float".equals(model.getType())) {
                return new FloatExample(0.0f);
            }
            if ("double".equals(model.getType())) {
                return new DoubleExample(0.0);
            }
        }
        return output;
    }

    public static void mergeTo(ObjectExample output, List<Example> examples) {
        for (Example ex : examples) {
            ObjectExample objectExample;
            Map<String, Example> values;
            if (!(ex instanceof ObjectExample) || (values = (objectExample = (ObjectExample)ex).getValues()) == null) continue;
            output.putAll(values);
        }
    }

    public static enum RequestType {
        READ,
        WRITE;

    }
}

