/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.processors;

import io.swagger.oas.inflector.converters.ConversionException;
import io.swagger.oas.inflector.processors.BinaryProcessor;
import io.swagger.oas.inflector.processors.EntityProcessor;
import io.swagger.oas.inflector.processors.JacksonProcessor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityProcessorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityProcessorFactory.class);
    private static List<EntityProcessor> PROCESSORS = new ArrayList<EntityProcessor>();

    public static void addProcessor(Class<?> cls, MediaType type) {
        for (EntityProcessor entityProcessor : PROCESSORS) {
            if (!entityProcessor.getClass().equals(cls)) continue;
            entityProcessor.enableType(type);
            return;
        }
        try {
            EntityProcessor processor = (EntityProcessor)cls.newInstance();
            PROCESSORS.add(processor);
            processor.enableType(type);
        }
        catch (Exception e) {
            LOGGER.debug("unable to add processor " + cls.getName());
        }
    }

    public static Object readValue(MediaType mediaType, InputStream entityStream, Class<?> class1) throws ConversionException {
        for (EntityProcessor p : EntityProcessorFactory.getProcessors()) {
            if (!p.supports(mediaType)) continue;
            return p.process(mediaType, entityStream, class1);
        }
        return null;
    }

    public static List<EntityProcessor> getProcessors() {
        return PROCESSORS;
    }

    static {
        PROCESSORS.add(new JacksonProcessor());
        PROCESSORS.add(new BinaryProcessor());
    }
}

