/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.oas.inflector.Constants;
import io.swagger.oas.inflector.config.Configuration;
import io.swagger.oas.inflector.models.RequestContext;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);
    protected Configuration config;
    protected Set<String> unimplementedMappedModels = new TreeSet<String>();
    private ClassNameValidator classNameValidator = new ClassNameValidator(){

        @Override
        public boolean isValidClassname(String classname) {
            try {
                return Class.forName(classname) != null;
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Failed to find class [" + classname + "]");
                return false;
            }
        }
    };

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public JavaType[] getOperationParameterClasses(Operation operation, String mediaType, Map<String, Schema> definitions) {
        TypeFactory tf = Json.mapper().getTypeFactory();
        if (operation.getParameters() == null) {
            operation.setParameters(new ArrayList());
        }
        int body = 0;
        JavaType[] bodyArgumentClasses = null;
        if (operation.getRequestBody() != null && (bodyArgumentClasses = this.getTypeFromRequestBody(operation.getRequestBody(), mediaType, definitions)) != null) {
            body = bodyArgumentClasses.length;
        }
        JavaType[] jt = new JavaType[operation.getParameters().size() + 1 + body];
        int i = 0;
        jt[i] = tf.constructType(RequestContext.class);
        ++i;
        for (Parameter parameter : operation.getParameters()) {
            JavaType argumentClasses;
            jt[i] = argumentClasses = this.getTypeFromParameter(parameter, definitions);
            ++i;
        }
        if (operation.getRequestBody() != null && bodyArgumentClasses != null) {
            JavaType[] javaTypeArray = bodyArgumentClasses;
            int n = javaTypeArray.length;
            for (int j = 0; j < n; ++j) {
                JavaType argument;
                jt[i] = argument = javaTypeArray[j];
                ++i;
            }
        }
        return jt;
    }

    public JavaType[] getTypeFromRequestBody(RequestBody body, String mediaType, Map<String, Schema> definitions) {
        JavaType[] jt = null;
        int i = 0;
        if (body.getContent() != null) {
            Content content = body.getContent();
            if (mediaType != null) {
                Schema model = ((MediaType)content.get(mediaType)).getSchema();
                if (mediaType.equals("multipart/form-data") || mediaType.equals("application/x-www-form-urlencoded")) {
                    if (model.getProperties() != null) {
                        Map properties = model.getProperties();
                        jt = new JavaType[properties.size()];
                        for (String key : properties.keySet()) {
                            Schema property = (Schema)properties.get(key);
                            JavaType javaType = this.getTypeFromProperty(property.getType(), property.getFormat(), property, definitions);
                            if (javaType != null) {
                                jt[i] = javaType;
                            }
                            ++i;
                        }
                        return jt;
                    }
                } else {
                    jt = new JavaType[1];
                    JavaType javaType = this.getTypeFromModel("", model, definitions);
                    if (javaType != null) {
                        jt[i] = javaType;
                    }
                }
            }
        }
        return jt;
    }

    public JavaType updateArgumentClass(Class<?> methodArg) {
        TypeFactory tf = Json.mapper().getTypeFactory();
        return tf.constructType(methodArg);
    }

    public JavaType getTypeFromParameter(Parameter parameter, Map<String, Schema> definitions) {
        if (parameter.getSchema() != null) {
            JavaType parameterType = this.getTypeFromProperty(parameter.getSchema().getType(), parameter.getSchema().getFormat(), parameter.getSchema(), definitions);
            if (parameterType != null) {
                return parameterType;
            }
        } else if (parameter.getContent() != null) {
            Content content = parameter.getContent();
            for (String mediaType : content.keySet()) {
                if (((MediaType)content.get(mediaType)).getSchema() == null) continue;
                Schema model = ((MediaType)content.get(mediaType)).getSchema();
                return this.getTypeFromModel("", model, definitions);
            }
        }
        return null;
    }

    public JavaType getTypeFromProperty(String type, String format, Schema property, Map<String, Schema> definitions) {
        TypeFactory tf = Json.mapper().getTypeFactory();
        if (property instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)property;
            Schema inner = arraySchema.getItems();
            JavaType innerType = this.getTypeFromProperty(null, null, inner, definitions);
            return tf.constructCollectionType(List.class, innerType);
        }
        if (property.getAdditionalProperties() != null && property.getAdditionalProperties() instanceof Schema) {
            Schema inner = (Schema)property.getAdditionalProperties();
            JavaType innerType = this.getTypeFromProperty(null, null, inner, definitions);
            return tf.constructMapLikeType(Map.class, this.getTypeFromProperty("string", null, null, definitions), innerType);
        }
        if (property.get$ref() != null && definitions != null) {
            JavaType mt;
            String ref = property.get$ref();
            Schema model = definitions.get(ref = ref.substring(ref.lastIndexOf("/") + 1));
            if (model != null && (mt = this.getTypeFromModel(ref, model, definitions)) != null) {
                return mt;
            }
        }
        if ("array".equals(type)) {
            JavaType innerType = this.getTypeFromProperty(null, null, property, definitions);
            return tf.constructCollectionType(List.class, innerType);
        }
        if ("byte".equals(type) || property instanceof ByteArraySchema) {
            return tf.constructType(Byte[].class);
        }
        if ("boolean".equals(type) || property instanceof BooleanSchema) {
            return tf.constructType(Boolean.class);
        }
        if ("string".equals(type) && "date".equals(format) || property instanceof DateSchema) {
            return tf.constructType(LocalDate.class);
        }
        if ("string".equals(type) && "date-time".equals(format) || property instanceof DateTimeSchema) {
            return tf.constructType(DateTime.class);
        }
        if ("string".equals(type) && format == null || property instanceof StringSchema) {
            return tf.constructType(String.class);
        }
        if ("number".equals(type) && format == null && property instanceof NumberSchema) {
            return tf.constructType(BigDecimal.class);
        }
        if ("number".equals(type) && "double".equals(format) && property instanceof NumberSchema) {
            return tf.constructType(Double.class);
        }
        if ("string".equals(type) && "email".equals(format) || property instanceof EmailSchema) {
            return tf.constructType(String.class);
        }
        if ("number".equals(type) && "float".equals(format) && property instanceof NumberSchema) {
            return tf.constructType(Float.class);
        }
        if ("string".equals(type) && "uuid".equals(format) || property instanceof UUIDSchema) {
            return tf.constructType(UUID.class);
        }
        if ("string".equals(type) && "binary".equals(format) || property instanceof FileSchema) {
            return tf.constructType(InputStream.class);
        }
        if ("integer".equals(type) && "int32".equals(format) && property instanceof IntegerSchema) {
            return tf.constructType(Integer.class);
        }
        if ("integer".equals(type) && "int64".equals(format) && property instanceof IntegerSchema) {
            return tf.constructType(Long.class);
        }
        if ("integer".equals(type)) {
            LOGGER.warn("falling back to `string` with format `" + format + "`");
            return tf.constructType(Long.class);
        }
        if ("string".equals(type) || property instanceof StringSchema) {
            LOGGER.warn("falling back to `string` with format `" + format + "`");
            return tf.constructType(String.class);
        }
        if (property instanceof ObjectSchema) {
            JavaType modelType;
            String name = null;
            if (property.getExtensions() != null) {
                name = (String)property.getExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL);
            }
            if (name != null && (modelType = this.getTypeFromModelName(name)) != null) {
                return modelType;
            }
            return tf.constructType(JsonNode.class);
        }
        return null;
    }

    public JavaType getTypeFromModel(String name, Schema model, Map<String, Schema> definitions) {
        JavaType innerType;
        ArraySchema arraySchema;
        JavaType modelType;
        String ref;
        TypeFactory tf = Json.mapper().getTypeFactory();
        if (model.get$ref() != null && "".equals(name)) {
            ref = model.get$ref();
            name = ref = ref.substring(ref.lastIndexOf("/") + 1);
        }
        if (this.config != null && this.config.getModelMapping(name) != null) {
            return tf.constructType(this.config.getModelMapping(name));
        }
        if (model.getExtensions() != null && model.getExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL) != null && (modelType = this.getTypeFromModelName((String)model.getExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL))) != null) {
            return modelType;
        }
        if (model.get$ref() != null) {
            ref = model.get$ref();
            Schema inner = definitions.get(ref = ref.substring(ref.lastIndexOf("/") + 1));
            if (inner != null) {
                return this.getTypeFromModel(name, inner, definitions);
            }
        }
        if (!"".equals(name)) {
            Class<?> cls;
            String modelName = name;
            if (this.config.getModelPackage() != null && name.indexOf(".") == -1) {
                modelName = this.config.getModelPackage() + "." + modelName;
            }
            if ((cls = this.loadClass(modelName)) != null) {
                return tf.constructType(cls);
            }
            if (model.getExtensions() == null || model.getExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL) == null) {
                this.unimplementedMappedModels.add(modelName);
            }
        }
        if (model instanceof ArraySchema && (arraySchema = (ArraySchema)model).getItems() != null) {
            innerType = this.getTypeFromProperty(arraySchema.getItems().getType(), arraySchema.getItems().getFormat(), arraySchema.getItems(), definitions);
            if (innerType != null) {
                return tf.constructArrayType(innerType);
            }
            return tf.constructArrayType(JsonNode.class);
        }
        if (model instanceof ObjectSchema) {
            return this.getTypeFromProperty(model.getType(), model.getFormat(), model, definitions);
        }
        if (model instanceof StringSchema) {
            StringSchema stringSchema = (StringSchema)model;
            innerType = this.getTypeFromProperty(stringSchema.getType(), stringSchema.getFormat(), (Schema)stringSchema, definitions);
            if (innerType != null) {
                return tf.constructType((Type)innerType);
            }
            return tf.constructType(JsonNode.class);
        }
        if (model instanceof DateSchema) {
            DateSchema dateSchema = (DateSchema)model;
            innerType = this.getTypeFromProperty(dateSchema.getType(), dateSchema.getFormat(), (Schema)dateSchema, definitions);
            if (innerType != null) {
                return tf.constructType((Type)innerType);
            }
            return tf.constructType(JsonNode.class);
        }
        if (model instanceof BooleanSchema) {
            BooleanSchema booleanSchema = (BooleanSchema)model;
            innerType = this.getTypeFromProperty(booleanSchema.getType(), booleanSchema.getFormat(), (Schema)booleanSchema, definitions);
            if (innerType != null) {
                return tf.constructType((Type)innerType);
            }
            return tf.constructType(JsonNode.class);
        }
        if (model instanceof DateTimeSchema) {
            DateTimeSchema dateTimeSchema = (DateTimeSchema)model;
            innerType = this.getTypeFromProperty(dateTimeSchema.getType(), dateTimeSchema.getFormat(), (Schema)dateTimeSchema, definitions);
            if (innerType != null) {
                return tf.constructType((Type)innerType);
            }
            return tf.constructType(JsonNode.class);
        }
        if (model instanceof IntegerSchema) {
            IntegerSchema integerSchema = (IntegerSchema)model;
            innerType = this.getTypeFromProperty(integerSchema.getType(), integerSchema.getFormat(), (Schema)integerSchema, definitions);
            if (innerType != null) {
                return tf.constructType((Type)innerType);
            }
            return tf.constructType(JsonNode.class);
        }
        if (model instanceof NumberSchema) {
            NumberSchema numberSchema = (NumberSchema)model;
            innerType = this.getTypeFromProperty(numberSchema.getType(), numberSchema.getFormat(), (Schema)numberSchema, definitions);
            if (innerType != null) {
                return tf.constructType((Type)innerType);
            }
            return tf.constructType(JsonNode.class);
        }
        if (model instanceof Schema) {
            return this.getTypeFromProperty(model.getType(), model.getFormat(), model, definitions);
        }
        return tf.constructType(JsonNode.class);
    }

    public Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String sanitizeToJava(String operationId) {
        String op = operationId.trim();
        if ((op = op.replaceAll("[^a-zA-Z0-9]", "_")).length() == 0) {
            return "nullId";
        }
        return op;
    }

    public String getMethodName(String path, String httpMethod, Operation operation) {
        String output = operation.getOperationId();
        if (output != null) {
            return this.sanitizeToJava(output);
        }
        String tmpPath = path;
        tmpPath = tmpPath.replaceAll("\\{", "");
        tmpPath = tmpPath.replaceAll("\\}", "");
        String[] parts = (tmpPath + "/" + httpMethod).split("/");
        StringBuilder builder = new StringBuilder();
        if ("/".equals(tmpPath)) {
            builder.append("root");
        }
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.length() <= 0) continue;
            part = builder.toString().length() == 0 ? Character.toLowerCase(part.charAt(0)) + part.substring(1) : StringUtils.capitalize((String)part);
            builder.append(part);
        }
        output = builder.toString();
        LOGGER.warn("generated operationId " + output);
        return output;
    }

    public String getControllerName(Operation operation) {
        String controllerClass;
        String name = null;
        if (operation.getExtensions() != null) {
            name = (String)operation.getExtensions().get(Constants.X_SWAGGER_ROUTER_CONTROLLER);
        }
        if (name != null) {
            if ((name = name.replaceAll("^\"|\"$", "")).indexOf(".") == -1 && this.config.getControllerPackage() != null) {
                name = this.config.getControllerPackage() + "." + name;
            }
            if (this.classNameValidator.isValidClassname(name)) {
                return name;
            }
        }
        if (operation.getTags() != null && operation.getTags().size() > 0) {
            for (String tag : operation.getTags()) {
                name = StringUtils.capitalize((String)this.sanitizeToJava(tag));
                if (this.config.getControllerPackage() != null) {
                    name = this.config.getControllerPackage() + "." + name;
                }
                if (this.classNameValidator.isValidClassname(name)) {
                    return name;
                }
                if (this.classNameValidator.isValidClassname(name + "Controller")) {
                    return name + "Controller";
                }
                if (this.classNameValidator.isValidClassname(this.sanitizeToJava("default"))) {
                    return this.sanitizeToJava("default");
                }
                if (!this.classNameValidator.isValidClassname(this.sanitizeToJava("default"))) continue;
                return this.sanitizeToJava("default") + "Controller";
            }
        }
        if (StringUtils.isEmpty((String)(controllerClass = this.config.getControllerClass()))) {
            controllerClass = StringUtils.capitalize((String)this.sanitizeToJava("default"));
        }
        return this.config.getControllerPackage() + "." + controllerClass;
    }

    public Set<String> getUnimplementedMappedModels() {
        return this.unimplementedMappedModels;
    }

    public void setUnimplementedMappedModels(Set<String> unimplementedMappedModels) {
        this.unimplementedMappedModels = unimplementedMappedModels;
    }

    public ClassNameValidator getClassNameValidator() {
        return this.classNameValidator;
    }

    public void setClassNameValidator(ClassNameValidator classNameValidator) {
        this.classNameValidator = classNameValidator;
    }

    private JavaType getTypeFromModelName(String name) {
        TypeFactory tf = Json.mapper().getTypeFactory();
        String modelName = name.replaceAll("^\"|\"$", "");
        Class<?> cls = this.loadClass(modelName);
        if (cls != null) {
            return tf.constructType(cls);
        }
        if (this.config.getModelPackage() != null && !modelName.contains(".") && (cls = this.loadClass(modelName = this.config.getModelPackage() + "." + modelName)) != null) {
            return tf.constructType(cls);
        }
        this.unimplementedMappedModels.add(modelName);
        return null;
    }

    public static interface ClassNameValidator {
        public boolean isValidClassname(String var1);
    }
}

