/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.testtools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.junit.runner.RunWith;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.Verticle;
import org.vertx.testtools.JavaClassRunner;
import org.vertx.testtools.VertxAssert;

@RunWith(value=JavaClassRunner.class)
public abstract class TestVerticle
extends Verticle {
    private static final Logger log = LoggerFactory.getLogger(TestVerticle.class);

    public void start() {
        this.initialize();
        this.startTests();
    }

    protected void initialize() {
        VertxAssert.initialize(this.vertx);
    }

    protected void startTests() {
        String methodName = this.container.config().getString("methodName");
        try {
            Method m = ((Object)((Object)this)).getClass().getDeclaredMethod(methodName, new Class[0]);
            m.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            InvocationTargetException it = e;
            Throwable targetEx = it.getTargetException();
            VertxAssert.handleThrowable(targetEx);
        }
        catch (Throwable t) {
            VertxAssert.handleThrowable(t);
        }
    }
}

