/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.utils.FileSet;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DirectoryConfigStore
implements ConfigStore {
    private Vertx vertx;
    private File path;
    private final List<FileSet> filesets = new ArrayList<FileSet>();

    public DirectoryConfigStore(Vertx vertx, JsonObject configuration) {
        this.vertx = vertx;
        String path = configuration.getString("path");
        if (path == null) {
            throw new IllegalArgumentException("The `path` configuration is required.");
        }
        this.path = new File(path);
        if (this.path.isFile()) {
            throw new IllegalArgumentException("The `path` must not be a file");
        }
        JsonArray filesets = configuration.getJsonArray("filesets");
        if (filesets == null) {
            throw new IllegalArgumentException("The `filesets` element is required.");
        }
        for (Object o : filesets) {
            JsonObject json = (JsonObject)o;
            FileSet set = new FileSet(vertx, this.path, json);
            this.filesets.add(set);
        }
    }

    @Override
    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        this.vertx.executeBlocking(fut -> {
            try {
                fut.complete(FileSet.traverse(this.path).stream().sorted().collect(Collectors.toList()));
            }
            catch (Throwable e) {
                fut.fail(e);
            }
        }, ar -> {
            if (ar.failed()) {
                completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                ArrayList<Future> futures = new ArrayList<Future>();
                for (FileSet set : this.filesets) {
                    Future future = Future.future();
                    set.buildConfiguration((List)ar.result(), (Handler<AsyncResult<JsonObject>>)((Handler)json -> {
                        if (json.failed()) {
                            future.fail(json.cause());
                        } else {
                            future.complete(json.result());
                        }
                    }));
                    futures.add(future);
                }
                CompositeFuture.all(futures).setHandler(cf -> {
                    if (cf.failed()) {
                        completionHandler.handle((Object)Future.failedFuture((Throwable)cf.cause()));
                    } else {
                        JsonObject json = new JsonObject();
                        futures.stream().map(f -> (JsonObject)f.result()).forEach(arg_0 -> ((JsonObject)json).mergeIn(arg_0));
                        completionHandler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)json.encode())));
                    }
                });
            }
        });
    }
}

