/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;

@VertxGen
public interface Promise<T>
extends Handler<AsyncResult<T>> {
    public static <T> Promise<T> succeededPromise() {
        return Future.factory.succeededPromise();
    }

    public static <T> Promise<T> succeededPromise(T result) {
        return Future.factory.succeededPromise(result);
    }

    public static <T> Promise<T> failedPromise(Throwable cause) {
        return Future.factory.failedPromise(cause);
    }

    public static <T> Promise<T> failedPromise(String failureMessage) {
        return Future.factory.failurePromise(failureMessage);
    }

    public static <T> Promise<T> promise() {
        return Future.factory.promise();
    }

    @Override
    @GenIgnore
    public void handle(AsyncResult<T> var1);

    public void complete(T var1);

    public void complete();

    public void fail(Throwable var1);

    public void fail(String var1);

    public boolean tryComplete(T var1);

    public boolean tryComplete();

    public boolean tryFail(Throwable var1);

    public boolean tryFail(String var1);

    @CacheReturn
    public Future<T> future();
}

