/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.tracing.VertxTracer;

class WorkerContext
extends ContextImpl {
    WorkerContext(VertxInternal vertx, VertxTracer<?, ?> tracer, WorkerPool internalBlockingPool, WorkerPool workerPool, Deployment deployment, ClassLoader tccl) {
        super(vertx, tracer, internalBlockingPool, workerPool, deployment, tccl);
    }

    @Override
    void executeAsync(Handler<Void> task) {
        this.execute(null, task);
    }

    @Override
    public boolean isEventLoopContext() {
        return false;
    }

    @Override
    <T> void execute(T value, Handler<T> task) {
        this.execute(this, value, task);
    }

    private <T> void execute(ContextInternal ctx, T value, Handler<T> task) {
        PoolMetrics metrics = this.workerPool.metrics();
        Object queueMetric = metrics != null ? metrics.submitted() : null;
        this.orderedTasks.execute(() -> {
            Object execMetric = null;
            if (metrics != null) {
                execMetric = metrics.begin(queueMetric);
            }
            try {
                ctx.dispatch(value, task);
            }
            finally {
                if (metrics != null) {
                    metrics.end(execMetric, true);
                }
            }
        }, this.workerPool.executor());
    }

    @Override
    public <T> void schedule(T value, Handler<T> task) {
        PoolMetrics metrics = this.workerPool.metrics();
        Object metric = metrics != null ? metrics.submitted() : null;
        this.orderedTasks.execute(() -> {
            if (metrics != null) {
                metrics.begin(metric);
            }
            try {
                task.handle(value);
            }
            finally {
                if (metrics != null) {
                    metrics.end(metric, true);
                }
            }
        }, this.workerPool.executor());
    }

    @Override
    public ContextInternal duplicate(ContextInternal in) {
        return new Duplicated(this, in);
    }

    static class Duplicated
    extends ContextImpl.Duplicated<WorkerContext> {
        Duplicated(WorkerContext delegate, ContextInternal other) {
            super(delegate, other);
        }

        @Override
        void executeAsync(Handler<Void> task) {
            this.execute(null, task);
        }

        @Override
        <T> void execute(T value, Handler<T> task) {
            ((WorkerContext)this.delegate).execute(this, value, task);
        }

        @Override
        public boolean isEventLoopContext() {
            return false;
        }

        @Override
        public ContextInternal duplicate(ContextInternal context) {
            return new Duplicated((WorkerContext)this.delegate, context);
        }
    }
}

