/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.NoStackTraceThrowable;

@VertxGen
public interface Promise<T>
extends Handler<AsyncResult<T>> {
    public static <T> Promise<T> promise() {
        return Future.factory.promise();
    }

    @Override
    @GenIgnore
    default public void handle(AsyncResult<T> asyncResult) {
        if (asyncResult.succeeded()) {
            this.complete(asyncResult.result());
        } else {
            this.fail(asyncResult.cause());
        }
    }

    default public void complete(T result) {
        if (!this.tryComplete(result)) {
            throw new IllegalStateException("Result is already complete");
        }
    }

    default public void complete() {
        if (!this.tryComplete()) {
            throw new IllegalStateException("Result is already complete");
        }
    }

    default public void fail(Throwable cause) {
        if (!this.tryFail(cause)) {
            throw new IllegalStateException("Result is already complete");
        }
    }

    default public void fail(String message) {
        if (!this.tryFail(message)) {
            throw new IllegalStateException("Result is already complete");
        }
    }

    public boolean tryComplete(T var1);

    default public boolean tryComplete() {
        return this.tryComplete(null);
    }

    public boolean tryFail(Throwable var1);

    default public boolean tryFail(String message) {
        return this.tryFail(new NoStackTraceThrowable(message));
    }

    @CacheReturn
    public Future<T> future();
}

