/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.clustered;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.impl.CodecManager;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.HandlerHolder;
import io.vertx.core.eventbus.impl.HandlerRegistration;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.OutboundDeliveryContext;
import io.vertx.core.eventbus.impl.clustered.ClusteredHandlerHolder;
import io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import io.vertx.core.eventbus.impl.clustered.ConnectionHolder;
import io.vertx.core.eventbus.impl.clustered.Serializer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationInfo;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class ClusteredEventBus
extends EventBusImpl {
    private static final Logger log = LoggerFactory.getLogger(ClusteredEventBus.class);
    public static final String CLUSTER_PUBLIC_HOST_PROP_NAME = "vertx.cluster.public.host";
    public static final String CLUSTER_PUBLIC_PORT_PROP_NAME = "vertx.cluster.public.port";
    private static final Buffer PONG = Buffer.buffer(new byte[]{1});
    private final EventBusOptions options;
    private final ClusterManager clusterManager;
    private final NodeSelector nodeSelector;
    private final AtomicLong handlerSequence = new AtomicLong(0L);
    private final ConcurrentMap<String, ConnectionHolder> connections = new ConcurrentHashMap<String, ConnectionHolder>();
    private NodeInfo nodeInfo;
    private String nodeId;
    private NetServer server;

    public ClusteredEventBus(VertxInternal vertx, VertxOptions options, ClusterManager clusterManager, NodeSelector nodeSelector) {
        super(vertx);
        this.options = options.getEventBusOptions();
        this.clusterManager = clusterManager;
        this.nodeSelector = nodeSelector;
    }

    private NetServerOptions getServerOptions() {
        NetServerOptions serverOptions = new NetServerOptions(this.options.toJson());
        ClusteredEventBus.setCertOptions(serverOptions, this.options.getKeyCertOptions());
        ClusteredEventBus.setTrustOptions(serverOptions, this.options.getTrustOptions());
        return serverOptions;
    }

    static void setCertOptions(TCPSSLOptions options, KeyCertOptions keyCertOptions) {
        if (keyCertOptions == null) {
            return;
        }
        if (keyCertOptions instanceof JksOptions) {
            options.setKeyStoreOptions((JksOptions)keyCertOptions);
        } else if (keyCertOptions instanceof PfxOptions) {
            options.setPfxKeyCertOptions((PfxOptions)keyCertOptions);
        } else {
            options.setPemKeyCertOptions((PemKeyCertOptions)keyCertOptions);
        }
    }

    static void setTrustOptions(TCPSSLOptions sslOptions, TrustOptions options) {
        if (options == null) {
            return;
        }
        if (options instanceof JksOptions) {
            sslOptions.setTrustStoreOptions((JksOptions)options);
        } else if (options instanceof PfxOptions) {
            sslOptions.setPfxTrustOptions((PfxOptions)options);
        } else {
            sslOptions.setPemTrustOptions((PemTrustOptions)options);
        }
    }

    @Override
    public void start(Promise<Void> promise) {
        this.server = this.vertx.createNetServer(this.getServerOptions());
        this.server.connectHandler(this.getServerHandler());
        this.server.listen().flatMap(v -> {
            int serverPort = this.getClusterPublicPort(this.options, this.server.actualPort());
            String serverHost = this.getClusterPublicHost(this.options);
            this.nodeInfo = new NodeInfo(serverHost, serverPort, this.options.getClusterNodeMetadata());
            this.nodeId = this.clusterManager.getNodeId();
            Promise<Void> setPromise = Promise.promise();
            this.clusterManager.setNodeInfo(this.nodeInfo, setPromise);
            return setPromise.future();
        }).onSuccess(v -> {
            this.started = true;
            this.nodeSelector.eventBusStarted();
        }).onComplete(promise);
    }

    @Override
    public void close(Promise<Void> promise) {
        Promise<Void> parentClose = Promise.promise();
        super.close(parentClose);
        parentClose.future().onComplete(ar -> {
            if (this.server != null) {
                this.server.close((AsyncResult<Void> serverClose) -> {
                    if (serverClose.failed()) {
                        log.error("Failed to close server", serverClose.cause());
                    }
                    for (ConnectionHolder holder : this.connections.values()) {
                        holder.close();
                    }
                    promise.handle((AsyncResult<Void>)serverClose);
                });
            } else {
                promise.handle((AsyncResult<Void>)ar);
            }
        });
    }

    @Override
    public MessageImpl createMessage(boolean send, String address, MultiMap headers, Object body, String codecName) {
        Objects.requireNonNull(address, "no null address accepted");
        MessageCodec codec = this.codecManager.lookupCodec(body, codecName);
        ClusteredMessage msg = new ClusteredMessage(this.nodeId, address, headers, body, codec, send, this);
        return msg;
    }

    @Override
    protected <T> void onLocalRegistration(HandlerHolder<T> handlerHolder, Promise<Void> promise) {
        if (!handlerHolder.isReplyHandler()) {
            RegistrationInfo registrationInfo = new RegistrationInfo(this.nodeId, handlerHolder.getSeq(), handlerHolder.isLocalOnly());
            this.clusterManager.addRegistration(handlerHolder.getHandler().address, registrationInfo, Objects.requireNonNull(promise));
        } else if (promise != null) {
            promise.complete();
        }
    }

    @Override
    protected <T> HandlerHolder<T> createHandlerHolder(HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly, ContextInternal context) {
        return new ClusteredHandlerHolder<T>(registration, replyHandler, localOnly, context, this.handlerSequence.getAndIncrement());
    }

    @Override
    protected <T> void removeRegistration(HandlerHolder<T> handlerHolder, Promise<Void> completionHandler) {
        if (!handlerHolder.isReplyHandler()) {
            RegistrationInfo registrationInfo = new RegistrationInfo(this.nodeId, handlerHolder.getSeq(), handlerHolder.isLocalOnly());
            Promise<Void> promise = Promise.promise();
            this.clusterManager.removeRegistration(handlerHolder.getHandler().address, registrationInfo, promise);
            if (completionHandler != null) {
                promise.future().onComplete(completionHandler);
            } else {
                promise.future().onFailure(t -> log.error("Failed to remove sub", (Throwable)t));
            }
        } else {
            completionHandler.complete();
        }
    }

    @Override
    protected <T> void sendOrPub(OutboundDeliveryContext<T> sendContext) {
        if (((ClusteredMessage)sendContext.message).getRepliedTo() != null) {
            this.clusteredSendReply(((ClusteredMessage)sendContext.message).getRepliedTo(), sendContext);
        } else if (sendContext.options.isLocalOnly()) {
            super.sendOrPub(sendContext);
        } else {
            Serializer serializer = Serializer.get(sendContext.ctx);
            if (sendContext.message.isSend()) {
                serializer.queue(sendContext, this.nodeSelector::selectForSend, this::sendToNode, this::sendOrPublishFailed);
            } else {
                serializer.queue(sendContext, this.nodeSelector::selectForPublish, this::sendToNodes, this::sendOrPublishFailed);
            }
        }
    }

    private void sendOrPublishFailed(OutboundDeliveryContext<?> sendContext, Throwable cause) {
        if (log.isDebugEnabled()) {
            log.error("Failed to send message", cause);
        }
        sendContext.written(cause);
    }

    @Override
    protected String generateReplyAddress() {
        return "__vertx.reply." + UUID.randomUUID().toString();
    }

    @Override
    protected boolean isMessageLocal(MessageImpl msg) {
        ClusteredMessage clusteredMessage = (ClusteredMessage)msg;
        return !clusteredMessage.isFromWire();
    }

    private int getClusterPublicPort(EventBusOptions options, int actualPort) {
        int publicPort = Integer.getInteger(CLUSTER_PUBLIC_PORT_PROP_NAME, options.getClusterPublicPort());
        if (publicPort < 1) {
            publicPort = actualPort;
        }
        return publicPort;
    }

    private String getClusterPublicHost(EventBusOptions options) {
        String publicHost = System.getProperty(CLUSTER_PUBLIC_HOST_PROP_NAME, options.getClusterPublicHost());
        if (publicHost == null) {
            publicHost = options.getHost();
        }
        return publicHost;
    }

    private Handler<NetSocket> getServerHandler() {
        return socket -> {
            final RecordParser parser = RecordParser.newFixed(4);
            Handler<Buffer> handler = new Handler<Buffer>(){
                int size = -1;

                @Override
                public void handle(Buffer buff) {
                    if (this.size == -1) {
                        this.size = buff.getInt(0);
                        parser.fixedSizeMode(this.size);
                    } else {
                        ClusteredMessage received = new ClusteredMessage(ClusteredEventBus.this);
                        received.readFromWire(buff, ClusteredEventBus.this.codecManager);
                        if (ClusteredEventBus.this.metrics != null) {
                            ClusteredEventBus.this.metrics.messageRead(received.address(), buff.length());
                        }
                        parser.fixedSizeMode(4);
                        this.size = -1;
                        if (received.codec() == CodecManager.PING_MESSAGE_CODEC) {
                            socket.write(PONG);
                        } else {
                            ClusteredEventBus.this.deliverMessageLocally(received);
                        }
                    }
                }
            };
            parser.setOutput(handler);
            socket.handler((Handler)parser);
        };
    }

    private <T> void sendToNode(OutboundDeliveryContext<T> sendContext, String nodeId) {
        if (nodeId != null && !nodeId.equals(this.nodeId)) {
            this.sendRemote(sendContext, nodeId, sendContext.message);
        } else {
            super.sendOrPub(sendContext);
        }
    }

    private <T> void sendToNodes(OutboundDeliveryContext<T> sendContext, Iterable<String> nodeIds) {
        boolean sentRemote = false;
        if (nodeIds != null) {
            for (String nid : nodeIds) {
                if (!sentRemote) {
                    sentRemote = true;
                }
                this.sendToNode(sendContext, nid);
            }
        }
        if (!sentRemote) {
            super.sendOrPub(sendContext);
        }
    }

    private <T> void clusteredSendReply(String replyDest, OutboundDeliveryContext<T> sendContext) {
        MessageImpl message = sendContext.message;
        if (!replyDest.equals(this.nodeId)) {
            this.sendRemote(sendContext, replyDest, message);
        } else {
            super.sendOrPub(sendContext);
        }
    }

    private void sendRemote(OutboundDeliveryContext<?> sendContext, String remoteNodeId, MessageImpl message) {
        ConnectionHolder holder = (ConnectionHolder)this.connections.get(remoteNodeId);
        if (holder == null) {
            holder = new ConnectionHolder(this, remoteNodeId, this.options);
            ConnectionHolder prevHolder = this.connections.putIfAbsent(remoteNodeId, holder);
            if (prevHolder != null) {
                holder = prevHolder;
            } else {
                holder.connect();
            }
        }
        holder.writeMessage(sendContext);
    }

    ConcurrentMap<String, ConnectionHolder> connections() {
        return this.connections;
    }

    VertxInternal vertx() {
        return this.vertx;
    }

    EventBusOptions options() {
        return this.options;
    }
}

