/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptionsConverter;
import io.vertx.core.json.JsonObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

@DataObject(generateConverter=true)
public class RequestOptions {
    public static final HttpMethod DEFAULT_HTTP_METHOD = HttpMethod.GET;
    public static final String DEFAULT_HOST = null;
    public static final Integer DEFAULT_PORT = null;
    public static final Boolean DEFAULT_SSL = null;
    public static final String DEFAULT_URI = "";
    public static final boolean DEFAULT_FOLLOW_REDIRECTS = false;
    public static final long DEFAULT_TIMEOUT = 0L;
    private HttpMethod method;
    private String host;
    private Integer port;
    private Boolean ssl;
    private String uri;
    private MultiMap headers;
    private boolean followRedirects;
    private long timeout;

    public RequestOptions() {
        this.method = DEFAULT_HTTP_METHOD;
        this.host = DEFAULT_HOST;
        this.port = DEFAULT_PORT;
        this.ssl = DEFAULT_SSL;
        this.uri = DEFAULT_URI;
        this.followRedirects = false;
        this.timeout = 0L;
    }

    public RequestOptions(RequestOptions other) {
        this.setMethod(other.method);
        this.setHost(other.host);
        this.setPort(other.port);
        this.setSsl(other.ssl);
        this.setURI(other.uri);
        this.setFollowRedirects(other.followRedirects);
        this.setTimeout(other.timeout);
        if (other.headers != null) {
            this.setHeaders(MultiMap.caseInsensitiveMultiMap().setAll(other.headers));
        }
    }

    public RequestOptions(JsonObject json) {
        RequestOptionsConverter.fromJson(json, this);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public RequestOptions setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public RequestOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public RequestOptions setPort(Integer port) {
        this.port = port;
        return this;
    }

    public Boolean isSsl() {
        return this.ssl;
    }

    public RequestOptions setSsl(Boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public String getURI() {
        return this.uri;
    }

    public RequestOptions setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public RequestOptions setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RequestOptions setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    private URL parseUrl(String surl) {
        try {
            return new URL(surl);
        }
        catch (MalformedURLException e) {
            throw new VertxException("Invalid url: " + surl, e);
        }
    }

    public RequestOptions setAbsoluteURI(String absoluteURI) {
        String protocol;
        Objects.requireNonNull(absoluteURI, "Cannot set a null absolute URI");
        URL url = this.parseUrl(absoluteURI);
        Boolean ssl = false;
        int port = url.getPort();
        String relativeUri = url.getPath().isEmpty() ? "/" + url.getFile() : url.getFile();
        switch (protocol = url.getProtocol()) {
            case "http": {
                if (port != -1) break;
                port = 80;
                break;
            }
            case "https": {
                ssl = true;
                if (port != -1) break;
                port = 443;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.uri = relativeUri;
        this.port = port;
        this.ssl = ssl;
        this.host = url.getHost();
        return this;
    }

    public RequestOptions addHeader(String key, String value) {
        return this.addHeader((CharSequence)key, (CharSequence)value);
    }

    @GenIgnore
    public RequestOptions addHeader(CharSequence key, CharSequence value) {
        this.checkHeaders();
        Objects.requireNonNull(key, "no null key accepted");
        Objects.requireNonNull(value, "no null value accepted");
        this.headers.add(key, value);
        return this;
    }

    @GenIgnore
    public RequestOptions addHeader(CharSequence key, Iterable<CharSequence> values) {
        this.checkHeaders();
        Objects.requireNonNull(key, "no null key accepted");
        Objects.requireNonNull(values, "no null values accepted");
        this.headers.add(key, values);
        return this;
    }

    @GenIgnore
    public RequestOptions setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    @GenIgnore
    public MultiMap getHeaders() {
        return this.headers;
    }

    private void checkHeaders() {
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RequestOptionsConverter.toJson(this, json);
        return json;
    }
}

