/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.util.function.Function;

public class CompositeFutureImpl
implements CompositeFuture {
    private static final Function<CompositeFuture, Object> ALL = cf -> {
        int size = cf.size();
        for (int i = 0; i < size; ++i) {
            if (cf.succeeded(i)) continue;
            return cf.cause(i);
        }
        return cf;
    };
    private final Future[] results;
    private int count;
    private Object result;
    private Promise<CompositeFuture> promise;

    public static CompositeFuture all(Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (Future<?> result : results) {
            result.onComplete((AsyncResult<T> ar) -> {
                if (ar.succeeded()) {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        ++composite.count;
                        if (composite.isComplete() || composite.count < len) {
                            return;
                        }
                    }
                    composite.succeed();
                } else {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (composite.isComplete()) {
                            return;
                        }
                    }
                    composite.fail(ar.cause());
                }
            });
        }
        if (len == 0) {
            composite.succeed();
        }
        return composite;
    }

    public static CompositeFuture any(Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (Future<?> result : results) {
            result.onComplete((AsyncResult<T> ar) -> {
                if (ar.succeeded()) {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (composite.isComplete()) {
                            return;
                        }
                    }
                    composite.succeed();
                } else {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        ++composite.count;
                        if (composite.isComplete() || composite.count < len) {
                            return;
                        }
                    }
                    composite.fail(ar.cause());
                }
            });
        }
        if (results.length == 0) {
            composite.succeed();
        }
        return composite;
    }

    public static CompositeFuture join(Future<?> ... results) {
        return CompositeFutureImpl.join(ALL, results);
    }

    private static CompositeFuture join(Function<CompositeFuture, Object> pred, Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (Future<?> result : results) {
            result.onComplete((AsyncResult<T> ar) -> {
                CompositeFutureImpl compositeFutureImpl = composite;
                synchronized (compositeFutureImpl) {
                    ++composite.count;
                    if (composite.isComplete() || composite.count < len) {
                        return;
                    }
                }
                composite.complete(pred.apply(composite));
            });
        }
        if (len == 0) {
            composite.succeed();
        }
        return composite;
    }

    private CompositeFutureImpl(Future<?> ... results) {
        this.results = results;
        this.promise = Promise.promise();
    }

    @Override
    public CompositeFuture onComplete(Handler<AsyncResult<CompositeFuture>> handler) {
        this.promise.future().onComplete(handler);
        return this;
    }

    @Override
    public Throwable cause(int index) {
        return this.future(index).cause();
    }

    @Override
    public boolean succeeded(int index) {
        return this.future(index).succeeded();
    }

    @Override
    public boolean failed(int index) {
        return this.future(index).failed();
    }

    @Override
    public boolean isComplete(int index) {
        return this.future(index).isComplete();
    }

    @Override
    public <T> T resultAt(int index) {
        return this.future(index).result();
    }

    private <T> Future<T> future(int index) {
        if (index < 0 || index > this.results.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.results[index];
    }

    @Override
    public int size() {
        return this.results.length;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.result != null;
    }

    @Override
    public synchronized boolean succeeded() {
        return this.result == this;
    }

    @Override
    public synchronized boolean failed() {
        return this.result instanceof Throwable;
    }

    @Override
    public synchronized Throwable cause() {
        return this.result instanceof Throwable ? (Throwable)this.result : null;
    }

    @Override
    public synchronized CompositeFuture result() {
        return this.result == this ? this : null;
    }

    private void succeed() {
        this.complete(this);
    }

    private void fail(Throwable t) {
        this.complete(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(Object result) {
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            this.result = result;
        }
        this.promise.handle(this);
    }
}

