/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.shareddata.Lock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class LocalAsyncLocks {
    private final ConcurrentMap<String, List<LockWaiter>> waitersMap = new ConcurrentHashMap<String, List<LockWaiter>>();

    public Future<Lock> acquire(ContextInternal context, String name, long timeout) {
        PromiseInternal<Lock> promise = context.promise();
        LockWaiter lockWaiter = new LockWaiter(context, name, timeout, promise);
        List waiters = this.waitersMap.compute(name, (s, list) -> {
            ArrayList<LockWaiter> result;
            if (list != null) {
                result = new ArrayList(list.size() + 1);
                result.addAll((Collection<LockWaiter>)list);
            } else {
                result = new ArrayList<LockWaiter>(1);
            }
            result.add(lockWaiter);
            return result;
        });
        if (waiters.size() == 1) {
            ((LockWaiter)waiters.get(0)).acquireLock();
        }
        return promise.future();
    }

    private void nextWaiter(String lockName) {
        List waiters = this.waitersMap.compute(lockName, (s, list) -> list == null || list.size() == 1 ? null : new ArrayList(list.subList(1, list.size())));
        if (waiters != null) {
            ((LockWaiter)waiters.get(0)).acquireLock();
        }
    }

    private class AsyncLock
    implements Lock {
        final String lockName;
        final AtomicBoolean invoked = new AtomicBoolean();

        AsyncLock(String lockName) {
            this.lockName = lockName;
        }

        @Override
        public void release() {
            if (this.invoked.compareAndSet(false, true)) {
                LocalAsyncLocks.this.nextWaiter(this.lockName);
            }
        }
    }

    private class LockWaiter {
        final Context context;
        final String lockName;
        final Promise<Lock> promise;
        final AtomicReference<Status> status;
        final Long timerId;

        LockWaiter(Context context, String lockName, long timeout, Promise<Lock> promise) {
            this.context = context;
            this.lockName = lockName;
            this.promise = promise;
            this.status = new AtomicReference<Status>(Status.WAITING);
            this.timerId = timeout != Long.MAX_VALUE ? Long.valueOf(context.owner().setTimer(timeout, tid -> this.timeout())) : null;
        }

        boolean isWaiting() {
            return this.status.get() == Status.WAITING;
        }

        void timeout() {
            if (this.status.compareAndSet(Status.WAITING, Status.TIMED_OUT)) {
                this.promise.fail("Timed out waiting to get lock");
            }
        }

        void acquireLock() {
            if (this.status.compareAndSet(Status.WAITING, Status.ACQUIRED)) {
                if (this.timerId != null) {
                    this.context.owner().cancelTimer(this.timerId);
                }
                this.promise.complete(new AsyncLock(this.lockName));
            } else {
                this.context.runOnContext(v -> LocalAsyncLocks.this.nextWaiter(this.lockName));
            }
        }
    }

    private static enum Status {
        WAITING,
        ACQUIRED,
        TIMED_OUT;

    }
}

