/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;

class DatagramSocketMetricsImpl
extends AbstractMetrics
implements DatagramSocketMetrics {
    private Counter socketsCounter = this.counter("sockets");
    private Histogram bytesRead;
    private Histogram bytesWritten;
    private Counter exceptions = this.counter("exceptions");

    DatagramSocketMetricsImpl(AbstractMetrics metrics, String baseName) {
        super(metrics.registry(), baseName);
        this.bytesWritten = this.histogram("bytes-written");
        this.socketsCounter.inc();
    }

    public void close() {
        this.socketsCounter.dec();
        this.removeAll();
    }

    public void listening(String localName, SocketAddress localAddress) {
        String serverName = localName + ':' + localAddress.port();
        this.bytesRead = this.histogram(serverName, "bytes-read");
    }

    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        if (this.bytesRead != null) {
            this.bytesRead.update(numberOfBytes);
        }
    }

    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.bytesWritten.update(numberOfBytes);
    }

    public void exceptionOccurred(Void socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.exceptions.inc();
    }
}

