/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;
import java.util.concurrent.TimeUnit;

class TCPMetricsImpl
extends AbstractMetrics
implements TCPMetrics<Long> {
    private Counter openConnections = this.counter("open-netsockets");
    private Timer connections = this.timer("connections");
    private Histogram bytesRead;
    private Histogram bytesWritten;
    private Counter exceptions = this.counter("exceptions");
    protected volatile boolean closed;

    TCPMetricsImpl(MetricRegistry registry, String baseName) {
        super(registry, baseName);
        this.bytesRead = this.histogram("bytes-read");
        this.bytesWritten = this.histogram("bytes-written");
    }

    public void close() {
        this.closed = true;
        this.removeAll();
    }

    public Long connected(SocketAddress remoteAddress, String remoteName) {
        this.openConnections.inc();
        if (remoteAddress != null) {
            this.counter("open-connections", remoteAddress.host()).inc();
        }
        if (this.closed) {
            this.removeAll();
        }
        return System.nanoTime();
    }

    public void disconnected(Long ctx, SocketAddress remoteAddress) {
        this.openConnections.dec();
        this.connections.update(System.nanoTime() - ctx, TimeUnit.NANOSECONDS);
        if (remoteAddress != null) {
            Counter counter = this.counter("open-connections", remoteAddress.host());
            counter.dec();
            if (counter.getCount() == 0L) {
                this.remove("open-connections", remoteAddress.host());
            }
        }
        if (this.closed) {
            this.removeAll();
        }
    }

    public void bytesRead(Long socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        if (numberOfBytes > 0L) {
            this.bytesRead.update(numberOfBytes);
        }
    }

    public void bytesWritten(Long socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        if (numberOfBytes > 0L) {
            this.bytesWritten.update(numberOfBytes);
        }
    }

    public void exceptionOccurred(Long socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.exceptions.inc();
    }

    protected long connections() {
        if (this.openConnections == null) {
            return 0L;
        }
        return this.openConnections.getCount();
    }

    static String addressName(SocketAddress address) {
        if (address == null) {
            return null;
        }
        return address.host() + ":" + address.port();
    }
}

