/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rxjava;

import io.vertx.core.Handler;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.streams.ReadStream;
import java.util.function.Function;

public class ReadStreamAdapter<J, R>
extends SingleOnSubscribeAdapter<R>
implements Handler<J> {
    private final io.vertx.core.streams.ReadStream<J> stream;
    private final Function<J, R> adapter;

    public ReadStreamAdapter(ReadStream<R> stream, Function<J, R> adapter) {
        this.adapter = adapter;
        this.stream = (io.vertx.core.streams.ReadStream)stream.getDelegate();
    }

    public void handle(J event) {
        this.fireNext(this.adapter.apply(event));
    }

    @Override
    public void execute() {
        this.stream.exceptionHandler(this::fireError);
        this.stream.endHandler(v -> this.fireComplete());
        this.stream.handler((Handler)this);
    }

    @Override
    public void onUnsubscribed() {
        try {
            this.stream.exceptionHandler(null);
            this.stream.endHandler(null);
            this.stream.handler(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

