/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;

public class ContextScheduler
extends Scheduler {
    private final Vertx vertx;
    private final boolean blocking;
    private static final Object DUMB = new JsonObject();

    public ContextScheduler(Vertx vertx, boolean blocking) {
        this.vertx = vertx;
        this.blocking = blocking;
    }

    public Scheduler.Worker createWorker() {
        return new WorkerImpl();
    }

    private class WorkerImpl
    extends Scheduler.Worker {
        private final ConcurrentHashMap<TimedAction, Object> actions = new ConcurrentHashMap();
        private final AtomicBoolean cancelled = new AtomicBoolean();

        private WorkerImpl() {
        }

        public Subscription schedule(Action0 action) {
            return this.schedule(action, 0L, TimeUnit.MILLISECONDS);
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            TimedAction timed = new TimedAction(action, unit.toMillis(delayTime), 0L);
            this.actions.put(timed, DUMB);
            return timed;
        }

        public Subscription schedulePeriodically(Action0 action, long initialDelay, long period, TimeUnit unit) {
            TimedAction timed = new TimedAction(action, unit.toMillis(initialDelay), unit.toMillis(period));
            this.actions.put(timed, DUMB);
            return timed;
        }

        public void unsubscribe() {
            if (this.cancelled.compareAndSet(false, true)) {
                ((ConcurrentHashMap.KeySetView)this.actions.keySet()).forEach(TimedAction::unsubscribe);
            }
        }

        public boolean isUnsubscribed() {
            return this.cancelled.get();
        }

        class TimedAction
        implements Subscription,
        Handler<Long>,
        Runnable {
            private long id;
            private final Action0 action;
            private final long periodMillis;
            private boolean cancelled = false;

            public TimedAction(Action0 action, long delayMillis, long periodMillis) {
                this.action = action;
                this.periodMillis = periodMillis;
                if (delayMillis > 0L) {
                    this.id = ContextScheduler.this.vertx.setTimer(delayMillis, (Handler)this);
                } else {
                    this.id = -1L;
                    if (ContextScheduler.this.blocking) {
                        ContextScheduler.this.vertx.executeBlocking(future -> this.run(), result -> {});
                    } else {
                        ContextScheduler.this.vertx.runOnContext(v -> this.run());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TimedAction timedAction = this;
                synchronized (timedAction) {
                    if (this.cancelled) {
                        return;
                    }
                }
                this.action.call();
                timedAction = this;
                synchronized (timedAction) {
                    if (this.periodMillis > 0L) {
                        this.id = ContextScheduler.this.vertx.setTimer(this.periodMillis, (Handler)this);
                    }
                }
            }

            public void handle(Long id) {
                if (ContextScheduler.this.blocking) {
                    ContextScheduler.this.vertx.executeBlocking(future -> this.run(), result -> {});
                } else {
                    this.run();
                }
            }

            public synchronized void unsubscribe() {
                if (!this.cancelled) {
                    WorkerImpl.this.actions.remove(this);
                    if (this.id > 0L) {
                        ContextScheduler.this.vertx.cancelTimer(this.id);
                    }
                    this.cancelled = true;
                }
            }

            public synchronized boolean isUnsubscribed() {
                return this.cancelled;
            }
        }
    }
}

