/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import io.vertx.core.Handler;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import rx.Observable;

public class ObservableHandler<T>
extends Observable<T> {
    private HandlerAdapter<T> adapter;

    public ObservableHandler() {
        this(new HandlerAdapter<T>(){

            @Override
            protected void dispatch(T event) {
                this.fireNext(event);
            }
        });
    }

    private ObservableHandler(HandlerAdapter<T> adapter) {
        super(adapter);
        this.adapter = adapter;
    }

    public Handler<T> toHandler() {
        return this.adapter;
    }

    private static abstract class HandlerAdapter<T>
    extends SingleOnSubscribeAdapter<T>
    implements Handler<T> {
        private boolean subscribed;

        private HandlerAdapter() {
        }

        @Override
        public void execute() {
            this.subscribed = true;
        }

        public void handle(T event) {
            if (this.subscribed) {
                this.dispatch(event);
            }
        }

        @Override
        protected void onUnsubscribed() {
            this.subscribed = false;
        }

        protected abstract void dispatch(T var1);
    }
}

