/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

public class SingleOnSubscribeAdapter<T>
implements Observable.OnSubscribe<T> {
    protected final AtomicReference<SingleSubscription> subRef = new AtomicReference();

    public void call(Subscriber<? super T> sub) {
        SingleSubscription singleSub = new SingleSubscription(sub);
        if (!this.subRef.compareAndSet(null, singleSub)) {
            throw new IllegalStateException("Cannot have multiple subscriptions");
        }
        sub.add((Subscription)singleSub);
        try {
            this.execute();
        }
        catch (Throwable t) {
            this.fireError(t);
        }
    }

    protected void execute() {
    }

    protected void onUnsubscribed() {
    }

    protected final void fireNext(T next) {
        Subscriber<T> s = this.getSubscriber();
        if (s != null) {
            s.onNext(next);
        }
    }

    protected final void fireResult(T res) {
        Subscriber<T> s = this.getSubscriber();
        if (s != null) {
            s.onNext(res);
            this.subRef.set(null);
            s.onCompleted();
        }
    }

    protected void fireComplete() {
        Subscriber<T> s = this.getSubscriber();
        if (s != null) {
            this.subRef.set(null);
            s.onCompleted();
        }
    }

    protected void fireError(Throwable t) {
        Subscriber<T> s = this.getSubscriber();
        if (s != null) {
            this.subRef.set(null);
            s.onError(t);
        }
    }

    protected Subscriber<? super T> getSubscriber() {
        SingleSubscription singleSub = this.subRef.get();
        return singleSub != null ? singleSub.subscriber : null;
    }

    class SingleSubscription
    implements Subscription {
        final Subscriber<? super T> subscriber;

        SingleSubscription(Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        public void unsubscribe() {
            if (this.isUnsubscribed()) {
                return;
            }
            if (SingleOnSubscribeAdapter.this.subRef.compareAndSet(this, null)) {
                SingleOnSubscribeAdapter.this.onUnsubscribed();
            }
        }

        public boolean isUnsubscribed() {
            return SingleOnSubscribeAdapter.this.subRef.get() != this;
        }
    }
}

