/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import rx.Observable;
import rx.Subscriber;

public abstract class UnmarshallerOperator<T, B>
implements Observable.Operator<T, B> {
    private final Class<T> mappedType;

    public UnmarshallerOperator(Class<T> mappedType) {
        this.mappedType = mappedType;
    }

    public abstract Buffer unwrap(B var1);

    public Subscriber<? super B> call(final Subscriber<? super T> subscriber) {
        final Buffer buffer = Buffer.buffer();
        return new Subscriber<B>(subscriber){

            public void onCompleted() {
                try {
                    Object obj = new ObjectMapper().readValue(buffer.getBytes(), UnmarshallerOperator.this.mappedType);
                    subscriber.onNext(obj);
                    subscriber.onCompleted();
                }
                catch (IOException e) {
                    this.onError(e);
                }
            }

            public void onError(Throwable e) {
                subscriber.onError(e);
            }

            public void onNext(B item) {
                buffer.appendBuffer(UnmarshallerOperator.this.unwrap(item));
            }
        };
    }
}

