/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.VertxOptions;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.lang.rxjava.InternalHelper;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.Context;
import io.vertx.rxjava.core.Future;
import io.vertx.rxjava.core.TimeoutStream;
import io.vertx.rxjava.core.datagram.DatagramSocket;
import io.vertx.rxjava.core.dns.DnsClient;
import io.vertx.rxjava.core.eventbus.EventBus;
import io.vertx.rxjava.core.file.FileSystem;
import io.vertx.rxjava.core.http.HttpClient;
import io.vertx.rxjava.core.http.HttpServer;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.rxjava.core.net.NetClient;
import io.vertx.rxjava.core.net.NetServer;
import io.vertx.rxjava.core.shareddata.SharedData;
import java.util.Set;
import rx.Observable;

public class Vertx
implements Measured {
    final io.vertx.core.Vertx delegate;
    private FileSystem cached_0;
    private EventBus cached_1;
    private SharedData cached_2;

    public Vertx(io.vertx.core.Vertx delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public static Vertx vertx() {
        Vertx ret = Vertx.newInstance(io.vertx.core.Vertx.vertx());
        return ret;
    }

    public static Vertx vertx(VertxOptions options) {
        Vertx ret = Vertx.newInstance(io.vertx.core.Vertx.vertx((VertxOptions)options));
        return ret;
    }

    public static void clusteredVertx(VertxOptions options, final Handler<AsyncResult<Vertx>> resultHandler) {
        io.vertx.core.Vertx.clusteredVertx((VertxOptions)options, (Handler)new Handler<AsyncResult<io.vertx.core.Vertx>>(){

            public void handle(AsyncResult<io.vertx.core.Vertx> event) {
                Object f = event.succeeded() ? InternalHelper.result(new Vertx((io.vertx.core.Vertx)event.result())) : InternalHelper.failure(event.cause());
                resultHandler.handle(f);
            }
        });
    }

    public static Observable<Vertx> clusteredVertxObservable(VertxOptions options) {
        ObservableFuture<Vertx> resultHandler = RxHelper.observableFuture();
        Vertx.clusteredVertx(options, resultHandler.toHandler());
        return resultHandler;
    }

    public static Context currentContext() {
        Context ret = Context.newInstance(io.vertx.core.Vertx.currentContext());
        return ret;
    }

    public Context getOrCreateContext() {
        Context ret = Context.newInstance(this.delegate.getOrCreateContext());
        return ret;
    }

    public NetServer createNetServer(NetServerOptions options) {
        NetServer ret = NetServer.newInstance(this.delegate.createNetServer(options));
        return ret;
    }

    public NetServer createNetServer() {
        NetServer ret = NetServer.newInstance(this.delegate.createNetServer());
        return ret;
    }

    public NetClient createNetClient(NetClientOptions options) {
        NetClient ret = NetClient.newInstance(this.delegate.createNetClient(options));
        return ret;
    }

    public NetClient createNetClient() {
        NetClient ret = NetClient.newInstance(this.delegate.createNetClient());
        return ret;
    }

    public HttpServer createHttpServer(HttpServerOptions options) {
        HttpServer ret = HttpServer.newInstance(this.delegate.createHttpServer(options));
        return ret;
    }

    public HttpServer createHttpServer() {
        HttpServer ret = HttpServer.newInstance(this.delegate.createHttpServer());
        return ret;
    }

    public HttpClient createHttpClient(HttpClientOptions options) {
        HttpClient ret = HttpClient.newInstance(this.delegate.createHttpClient(options));
        return ret;
    }

    public HttpClient createHttpClient() {
        HttpClient ret = HttpClient.newInstance(this.delegate.createHttpClient());
        return ret;
    }

    public DatagramSocket createDatagramSocket(DatagramSocketOptions options) {
        DatagramSocket ret = DatagramSocket.newInstance(this.delegate.createDatagramSocket(options));
        return ret;
    }

    public DatagramSocket createDatagramSocket() {
        DatagramSocket ret = DatagramSocket.newInstance(this.delegate.createDatagramSocket());
        return ret;
    }

    public FileSystem fileSystem() {
        FileSystem ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = FileSystem.newInstance(this.delegate.fileSystem());
        return ret;
    }

    public EventBus eventBus() {
        EventBus ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = EventBus.newInstance(this.delegate.eventBus());
        return ret;
    }

    public DnsClient createDnsClient(int port, String host) {
        DnsClient ret = DnsClient.newInstance(this.delegate.createDnsClient(port, host));
        return ret;
    }

    public SharedData sharedData() {
        SharedData ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = SharedData.newInstance(this.delegate.sharedData());
        return ret;
    }

    public long setTimer(long delay, Handler<Long> handler) {
        long ret = this.delegate.setTimer(delay, handler);
        return ret;
    }

    public TimeoutStream timerStream(long delay) {
        TimeoutStream ret = TimeoutStream.newInstance(this.delegate.timerStream(delay));
        return ret;
    }

    public long setPeriodic(long delay, Handler<Long> handler) {
        long ret = this.delegate.setPeriodic(delay, handler);
        return ret;
    }

    public TimeoutStream periodicStream(long delay) {
        TimeoutStream ret = TimeoutStream.newInstance(this.delegate.periodicStream(delay));
        return ret;
    }

    public boolean cancelTimer(long id) {
        boolean ret = this.delegate.cancelTimer(id);
        return ret;
    }

    public void runOnContext(Handler<Void> action) {
        this.delegate.runOnContext(action);
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public Observable<Void> closeObservable() {
        ObservableFuture<Void> completionHandler = RxHelper.observableFuture();
        this.close(completionHandler.toHandler());
        return completionHandler;
    }

    public void deployVerticle(String name) {
        this.delegate.deployVerticle(name);
    }

    public void deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) {
        this.delegate.deployVerticle(name, completionHandler);
    }

    public Observable<String> deployVerticleObservable(String name) {
        ObservableFuture<String> completionHandler = RxHelper.observableFuture();
        this.deployVerticle(name, completionHandler.toHandler());
        return completionHandler;
    }

    public void deployVerticle(String name, DeploymentOptions options) {
        this.delegate.deployVerticle(name, options);
    }

    public void deployVerticle(String name, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        this.delegate.deployVerticle(name, options, completionHandler);
    }

    public Observable<String> deployVerticleObservable(String name, DeploymentOptions options) {
        ObservableFuture<String> completionHandler = RxHelper.observableFuture();
        this.deployVerticle(name, options, completionHandler.toHandler());
        return completionHandler;
    }

    public void undeploy(String deploymentID) {
        this.delegate.undeploy(deploymentID);
    }

    public void undeploy(String deploymentID, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.undeploy(deploymentID, completionHandler);
    }

    public Observable<Void> undeployObservable(String deploymentID) {
        ObservableFuture<Void> completionHandler = RxHelper.observableFuture();
        this.undeploy(deploymentID, completionHandler.toHandler());
        return completionHandler;
    }

    public Set<String> deploymentIDs() {
        Set ret = this.delegate.deploymentIDs();
        return ret;
    }

    public boolean isClustered() {
        boolean ret = this.delegate.isClustered();
        return ret;
    }

    public <T> void executeBlocking(final Handler<Future<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>(){

            public void handle(io.vertx.core.Future<T> event) {
                blockingCodeHandler.handle(new Future(event));
            }
        }, ordered, resultHandler);
    }

    public <T> Observable<T> executeBlockingObservable(Handler<Future<T>> blockingCodeHandler, boolean ordered) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.executeBlocking(blockingCodeHandler, ordered, resultHandler.toHandler());
        return resultHandler;
    }

    public <T> void executeBlocking(final Handler<Future<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>(){

            public void handle(io.vertx.core.Future<T> event) {
                blockingCodeHandler.handle(new Future(event));
            }
        }, resultHandler);
    }

    public <T> Observable<T> executeBlockingObservable(Handler<Future<T>> blockingCodeHandler) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.executeBlocking(blockingCodeHandler, resultHandler.toHandler());
        return resultHandler;
    }

    public static Vertx newInstance(io.vertx.core.Vertx arg) {
        return arg != null ? new Vertx(arg) : null;
    }
}

