/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.buffer;

public class Buffer {
    final io.vertx.core.buffer.Buffer delegate;

    public Buffer(io.vertx.core.buffer.Buffer delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public static Buffer buffer() {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer());
        return ret;
    }

    public static Buffer buffer(int initialSizeHint) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer((int)initialSizeHint));
        return ret;
    }

    public static Buffer buffer(String string) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer((String)string));
        return ret;
    }

    public static Buffer buffer(String string, String enc) {
        Buffer ret = Buffer.newInstance(io.vertx.core.buffer.Buffer.buffer((String)string, (String)enc));
        return ret;
    }

    public String toString(String enc) {
        String ret = this.delegate.toString(enc);
        return ret;
    }

    public byte getByte(int pos) {
        byte ret = this.delegate.getByte(pos);
        return ret;
    }

    public int getInt(int pos) {
        int ret = this.delegate.getInt(pos);
        return ret;
    }

    public long getLong(int pos) {
        long ret = this.delegate.getLong(pos);
        return ret;
    }

    public double getDouble(int pos) {
        double ret = this.delegate.getDouble(pos);
        return ret;
    }

    public float getFloat(int pos) {
        float ret = this.delegate.getFloat(pos);
        return ret;
    }

    public short getShort(int pos) {
        short ret = this.delegate.getShort(pos);
        return ret;
    }

    public Buffer getBuffer(int start, int end) {
        Buffer ret = Buffer.newInstance(this.delegate.getBuffer(start, end));
        return ret;
    }

    public String getString(int start, int end, String enc) {
        String ret = this.delegate.getString(start, end, enc);
        return ret;
    }

    public String getString(int start, int end) {
        String ret = this.delegate.getString(start, end);
        return ret;
    }

    public Buffer appendBuffer(Buffer buff) {
        this.delegate.appendBuffer((io.vertx.core.buffer.Buffer)buff.getDelegate());
        return this;
    }

    public Buffer appendBuffer(Buffer buff, int offset, int len) {
        this.delegate.appendBuffer((io.vertx.core.buffer.Buffer)buff.getDelegate(), offset, len);
        return this;
    }

    public Buffer appendByte(byte b) {
        this.delegate.appendByte(b);
        return this;
    }

    public Buffer appendInt(int i) {
        this.delegate.appendInt(i);
        return this;
    }

    public Buffer appendLong(long l) {
        this.delegate.appendLong(l);
        return this;
    }

    public Buffer appendShort(short s) {
        this.delegate.appendShort(s);
        return this;
    }

    public Buffer appendFloat(float f) {
        this.delegate.appendFloat(f);
        return this;
    }

    public Buffer appendDouble(double d) {
        this.delegate.appendDouble(d);
        return this;
    }

    public Buffer appendString(String str, String enc) {
        this.delegate.appendString(str, enc);
        return this;
    }

    public Buffer appendString(String str) {
        this.delegate.appendString(str);
        return this;
    }

    public Buffer setByte(int pos, byte b) {
        this.delegate.setByte(pos, b);
        return this;
    }

    public Buffer setInt(int pos, int i) {
        this.delegate.setInt(pos, i);
        return this;
    }

    public Buffer setLong(int pos, long l) {
        this.delegate.setLong(pos, l);
        return this;
    }

    public Buffer setDouble(int pos, double d) {
        this.delegate.setDouble(pos, d);
        return this;
    }

    public Buffer setFloat(int pos, float f) {
        this.delegate.setFloat(pos, f);
        return this;
    }

    public Buffer setShort(int pos, short s) {
        this.delegate.setShort(pos, s);
        return this;
    }

    public Buffer setBuffer(int pos, Buffer b) {
        this.delegate.setBuffer(pos, (io.vertx.core.buffer.Buffer)b.getDelegate());
        return this;
    }

    public Buffer setBuffer(int pos, Buffer b, int offset, int len) {
        this.delegate.setBuffer(pos, (io.vertx.core.buffer.Buffer)b.getDelegate(), offset, len);
        return this;
    }

    public Buffer setString(int pos, String str) {
        this.delegate.setString(pos, str);
        return this;
    }

    public Buffer setString(int pos, String str, String enc) {
        this.delegate.setString(pos, str, enc);
        return this;
    }

    public int length() {
        int ret = this.delegate.length();
        return ret;
    }

    public Buffer copy() {
        Buffer ret = Buffer.newInstance(this.delegate.copy());
        return ret;
    }

    public Buffer slice() {
        Buffer ret = Buffer.newInstance(this.delegate.slice());
        return ret;
    }

    public Buffer slice(int start, int end) {
        Buffer ret = Buffer.newInstance(this.delegate.slice(start, end));
        return ret;
    }

    public static Buffer newInstance(io.vertx.core.buffer.Buffer arg) {
        return arg != null ? new Buffer(arg) : null;
    }
}

