/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.dns;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.InternalHelper;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.dns.MxRecord;
import io.vertx.rxjava.core.dns.SrvRecord;
import java.util.List;
import java.util.stream.Collectors;
import rx.Observable;

public class DnsClient {
    final io.vertx.core.dns.DnsClient delegate;

    public DnsClient(io.vertx.core.dns.DnsClient delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public DnsClient lookup(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup(name, handler);
        return this;
    }

    public Observable<String> lookupObservable(String name) {
        ObservableFuture<String> handler = RxHelper.observableFuture();
        this.lookup(name, handler.toHandler());
        return handler;
    }

    public DnsClient lookup4(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup4(name, handler);
        return this;
    }

    public Observable<String> lookup4Observable(String name) {
        ObservableFuture<String> handler = RxHelper.observableFuture();
        this.lookup4(name, handler.toHandler());
        return handler;
    }

    public DnsClient lookup6(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup6(name, handler);
        return this;
    }

    public Observable<String> lookup6Observable(String name) {
        ObservableFuture<String> handler = RxHelper.observableFuture();
        this.lookup6(name, handler.toHandler());
        return handler;
    }

    public DnsClient resolveA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveA(name, handler);
        return this;
    }

    public Observable<List<String>> resolveAObservable(String name) {
        ObservableFuture<List<String>> handler = RxHelper.observableFuture();
        this.resolveA(name, handler.toHandler());
        return handler;
    }

    public DnsClient resolveAAAA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveAAAA(name, handler);
        return this;
    }

    public Observable<List<String>> resolveAAAAObservable(String name) {
        ObservableFuture<List<String>> handler = RxHelper.observableFuture();
        this.resolveAAAA(name, handler.toHandler());
        return handler;
    }

    public DnsClient resolveCNAME(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveCNAME(name, handler);
        return this;
    }

    public Observable<List<String>> resolveCNAMEObservable(String name) {
        ObservableFuture<List<String>> handler = RxHelper.observableFuture();
        this.resolveCNAME(name, handler.toHandler());
        return handler;
    }

    public DnsClient resolveMX(String name, final Handler<AsyncResult<List<MxRecord>>> handler) {
        this.delegate.resolveMX(name, (Handler)new Handler<AsyncResult<List<io.vertx.core.dns.MxRecord>>>(){

            public void handle(AsyncResult<List<io.vertx.core.dns.MxRecord>> event) {
                Object f = event.succeeded() ? InternalHelper.result(((List)event.result()).stream().map(MxRecord::newInstance).collect(Collectors.toList())) : InternalHelper.failure(event.cause());
                handler.handle(f);
            }
        });
        return this;
    }

    public Observable<List<MxRecord>> resolveMXObservable(String name) {
        ObservableFuture<List<MxRecord>> handler = RxHelper.observableFuture();
        this.resolveMX(name, handler.toHandler());
        return handler;
    }

    public DnsClient resolveTXT(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveTXT(name, handler);
        return this;
    }

    public Observable<List<String>> resolveTXTObservable(String name) {
        ObservableFuture<List<String>> handler = RxHelper.observableFuture();
        this.resolveTXT(name, handler.toHandler());
        return handler;
    }

    public DnsClient resolvePTR(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.resolvePTR(name, handler);
        return this;
    }

    public Observable<String> resolvePTRObservable(String name) {
        ObservableFuture<String> handler = RxHelper.observableFuture();
        this.resolvePTR(name, handler.toHandler());
        return handler;
    }

    public DnsClient resolveNS(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveNS(name, handler);
        return this;
    }

    public Observable<List<String>> resolveNSObservable(String name) {
        ObservableFuture<List<String>> handler = RxHelper.observableFuture();
        this.resolveNS(name, handler.toHandler());
        return handler;
    }

    public DnsClient resolveSRV(String name, final Handler<AsyncResult<List<SrvRecord>>> handler) {
        this.delegate.resolveSRV(name, (Handler)new Handler<AsyncResult<List<io.vertx.core.dns.SrvRecord>>>(){

            public void handle(AsyncResult<List<io.vertx.core.dns.SrvRecord>> event) {
                Object f = event.succeeded() ? InternalHelper.result(((List)event.result()).stream().map(SrvRecord::newInstance).collect(Collectors.toList())) : InternalHelper.failure(event.cause());
                handler.handle(f);
            }
        });
        return this;
    }

    public Observable<List<SrvRecord>> resolveSRVObservable(String name) {
        ObservableFuture<List<SrvRecord>> handler = RxHelper.observableFuture();
        this.resolveSRV(name, handler.toHandler());
        return handler;
    }

    public DnsClient reverseLookup(String ipaddress, Handler<AsyncResult<String>> handler) {
        this.delegate.reverseLookup(ipaddress, handler);
        return this;
    }

    public Observable<String> reverseLookupObservable(String ipaddress) {
        ObservableFuture<String> handler = RxHelper.observableFuture();
        this.reverseLookup(ipaddress, handler.toHandler());
        return handler;
    }

    public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
        return arg != null ? new DnsClient(arg) : null;
    }
}

