/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.eventbus;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.ReadStreamAdapter;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.eventbus.Message;
import io.vertx.rxjava.core.streams.ReadStream;
import java.util.function.Function;
import rx.Observable;

public class MessageConsumer<T>
implements ReadStream<Message<T>> {
    final io.vertx.core.eventbus.MessageConsumer delegate;
    private Observable<Message<T>> observable;

    public MessageConsumer(io.vertx.core.eventbus.MessageConsumer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Message<T>> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.eventbus.Message, Message> conv = Message::newInstance;
            ReadStreamAdapter<io.vertx.core.eventbus.Message, Message> adapter = new ReadStreamAdapter<io.vertx.core.eventbus.Message, Message>(this, conv);
            this.observable = Observable.create(adapter);
        }
        return this.observable;
    }

    @Override
    public MessageConsumer<T> exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public MessageConsumer<T> handler(final Handler<Message<T>> handler) {
        this.delegate.handler(new Handler<io.vertx.core.eventbus.Message<T>>(){

            public void handle(io.vertx.core.eventbus.Message<T> event) {
                handler.handle(new Message(event));
            }
        });
        return this;
    }

    @Override
    public MessageConsumer<T> pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public MessageConsumer<T> resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public MessageConsumer<T> endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public ReadStream<T> bodyStream() {
        ReadStream ret = ReadStream.newInstance(this.delegate.bodyStream());
        return ret;
    }

    public boolean isRegistered() {
        boolean ret = this.delegate.isRegistered();
        return ret;
    }

    public String address() {
        String ret = this.delegate.address();
        return ret;
    }

    public MessageConsumer<T> setMaxBufferedMessages(int maxBufferedMessages) {
        MessageConsumer<T> ret = MessageConsumer.newInstance(this.delegate.setMaxBufferedMessages(maxBufferedMessages));
        return ret;
    }

    public int getMaxBufferedMessages() {
        int ret = this.delegate.getMaxBufferedMessages();
        return ret;
    }

    public void completionHandler(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.completionHandler(completionHandler);
    }

    public Observable<Void> completionHandlerObservable() {
        ObservableFuture<Void> completionHandler = RxHelper.observableFuture();
        this.completionHandler(completionHandler.toHandler());
        return completionHandler;
    }

    public void unregister() {
        this.delegate.unregister();
    }

    public void unregister(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.unregister(completionHandler);
    }

    public Observable<Void> unregisterObservable() {
        ObservableFuture<Void> completionHandler = RxHelper.observableFuture();
        this.unregister(completionHandler.toHandler());
        return completionHandler;
    }

    public static <T> MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg) {
        return arg != null ? new MessageConsumer<T>(arg) : null;
    }
}

