/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.file;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.file.OpenOptions;
import io.vertx.lang.rxjava.InternalHelper;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.file.AsyncFile;
import io.vertx.rxjava.core.file.FileProps;
import io.vertx.rxjava.core.file.FileSystemProps;
import java.util.List;
import rx.Observable;

public class FileSystem {
    final io.vertx.core.file.FileSystem delegate;

    public FileSystem(io.vertx.core.file.FileSystem delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public FileSystem copy(String from, String to, Handler<AsyncResult<Void>> handler) {
        this.delegate.copy(from, to, handler);
        return this;
    }

    public Observable<Void> copyObservable(String from, String to) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.copy(from, to, handler.toHandler());
        return handler;
    }

    public FileSystem copyBlocking(String from, String to) {
        this.delegate.copyBlocking(from, to);
        return this;
    }

    public FileSystem copyRecursive(String from, String to, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.delegate.copyRecursive(from, to, recursive, handler);
        return this;
    }

    public Observable<Void> copyRecursiveObservable(String from, String to, boolean recursive) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.copyRecursive(from, to, recursive, handler.toHandler());
        return handler;
    }

    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive) {
        this.delegate.copyRecursiveBlocking(from, to, recursive);
        return this;
    }

    public FileSystem move(String from, String to, Handler<AsyncResult<Void>> handler) {
        this.delegate.move(from, to, handler);
        return this;
    }

    public Observable<Void> moveObservable(String from, String to) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.move(from, to, handler.toHandler());
        return handler;
    }

    public FileSystem moveBlocking(String from, String to) {
        this.delegate.moveBlocking(from, to);
        return this;
    }

    public FileSystem truncate(String path, long len, Handler<AsyncResult<Void>> handler) {
        this.delegate.truncate(path, len, handler);
        return this;
    }

    public Observable<Void> truncateObservable(String path, long len) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.truncate(path, len, handler.toHandler());
        return handler;
    }

    public FileSystem truncateBlocking(String path, long len) {
        this.delegate.truncateBlocking(path, len);
        return this;
    }

    public FileSystem chmod(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.chmod(path, perms, handler);
        return this;
    }

    public Observable<Void> chmodObservable(String path, String perms) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.chmod(path, perms, handler.toHandler());
        return handler;
    }

    public FileSystem chmodBlocking(String path, String perms) {
        this.delegate.chmodBlocking(path, perms);
        return this;
    }

    public FileSystem chmodRecursive(String path, String perms, String dirPerms, Handler<AsyncResult<Void>> handler) {
        this.delegate.chmodRecursive(path, perms, dirPerms, handler);
        return this;
    }

    public Observable<Void> chmodRecursiveObservable(String path, String perms, String dirPerms) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.chmodRecursive(path, perms, dirPerms, handler.toHandler());
        return handler;
    }

    public FileSystem chmodRecursiveBlocking(String path, String perms, String dirPerms) {
        this.delegate.chmodRecursiveBlocking(path, perms, dirPerms);
        return this;
    }

    public FileSystem chown(String path, String user, String group, Handler<AsyncResult<Void>> handler) {
        this.delegate.chown(path, user, group, handler);
        return this;
    }

    public Observable<Void> chownObservable(String path, String user, String group) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.chown(path, user, group, handler.toHandler());
        return handler;
    }

    public FileSystem chownBlocking(String path, String user, String group) {
        this.delegate.chownBlocking(path, user, group);
        return this;
    }

    public FileSystem props(String path, final Handler<AsyncResult<FileProps>> handler) {
        this.delegate.props(path, (Handler)new Handler<AsyncResult<io.vertx.core.file.FileProps>>(){

            public void handle(AsyncResult<io.vertx.core.file.FileProps> event) {
                Object f = event.succeeded() ? InternalHelper.result(new FileProps((io.vertx.core.file.FileProps)event.result())) : InternalHelper.failure(event.cause());
                handler.handle(f);
            }
        });
        return this;
    }

    public Observable<FileProps> propsObservable(String path) {
        ObservableFuture<FileProps> handler = RxHelper.observableFuture();
        this.props(path, handler.toHandler());
        return handler;
    }

    public FileProps propsBlocking(String path) {
        FileProps ret = FileProps.newInstance(this.delegate.propsBlocking(path));
        return ret;
    }

    public FileSystem lprops(String path, final Handler<AsyncResult<FileProps>> handler) {
        this.delegate.lprops(path, (Handler)new Handler<AsyncResult<io.vertx.core.file.FileProps>>(){

            public void handle(AsyncResult<io.vertx.core.file.FileProps> event) {
                Object f = event.succeeded() ? InternalHelper.result(new FileProps((io.vertx.core.file.FileProps)event.result())) : InternalHelper.failure(event.cause());
                handler.handle(f);
            }
        });
        return this;
    }

    public Observable<FileProps> lpropsObservable(String path) {
        ObservableFuture<FileProps> handler = RxHelper.observableFuture();
        this.lprops(path, handler.toHandler());
        return handler;
    }

    public FileProps lpropsBlocking(String path) {
        FileProps ret = FileProps.newInstance(this.delegate.lpropsBlocking(path));
        return ret;
    }

    public FileSystem link(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.delegate.link(link, existing, handler);
        return this;
    }

    public Observable<Void> linkObservable(String link, String existing) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.link(link, existing, handler.toHandler());
        return handler;
    }

    public FileSystem linkBlocking(String link, String existing) {
        this.delegate.linkBlocking(link, existing);
        return this;
    }

    public FileSystem symlink(String link, String existing, Handler<AsyncResult<Void>> handler) {
        this.delegate.symlink(link, existing, handler);
        return this;
    }

    public Observable<Void> symlinkObservable(String link, String existing) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.symlink(link, existing, handler.toHandler());
        return handler;
    }

    public FileSystem symlinkBlocking(String link, String existing) {
        this.delegate.symlinkBlocking(link, existing);
        return this;
    }

    public FileSystem unlink(String link, Handler<AsyncResult<Void>> handler) {
        this.delegate.unlink(link, handler);
        return this;
    }

    public Observable<Void> unlinkObservable(String link) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.unlink(link, handler.toHandler());
        return handler;
    }

    public FileSystem unlinkBlocking(String link) {
        this.delegate.unlinkBlocking(link);
        return this;
    }

    public FileSystem readSymlink(String link, Handler<AsyncResult<String>> handler) {
        this.delegate.readSymlink(link, handler);
        return this;
    }

    public Observable<String> readSymlinkObservable(String link) {
        ObservableFuture<String> handler = RxHelper.observableFuture();
        this.readSymlink(link, handler.toHandler());
        return handler;
    }

    public String readSymlinkBlocking(String link) {
        String ret = this.delegate.readSymlinkBlocking(link);
        return ret;
    }

    public FileSystem delete(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.delete(path, handler);
        return this;
    }

    public Observable<Void> deleteObservable(String path) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.delete(path, handler.toHandler());
        return handler;
    }

    public FileSystem deleteBlocking(String path) {
        this.delegate.deleteBlocking(path);
        return this;
    }

    public FileSystem deleteRecursive(String path, boolean recursive, Handler<AsyncResult<Void>> handler) {
        this.delegate.deleteRecursive(path, recursive, handler);
        return this;
    }

    public Observable<Void> deleteRecursiveObservable(String path, boolean recursive) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.deleteRecursive(path, recursive, handler.toHandler());
        return handler;
    }

    public FileSystem deleteRecursiveBlocking(String path, boolean recursive) {
        this.delegate.deleteRecursiveBlocking(path, recursive);
        return this;
    }

    public FileSystem mkdir(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdir(path, handler);
        return this;
    }

    public Observable<Void> mkdirObservable(String path) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.mkdir(path, handler.toHandler());
        return handler;
    }

    public FileSystem mkdirBlocking(String path) {
        this.delegate.mkdirBlocking(path);
        return this;
    }

    public FileSystem mkdir(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdir(path, perms, handler);
        return this;
    }

    public Observable<Void> mkdirObservable(String path, String perms) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.mkdir(path, perms, handler.toHandler());
        return handler;
    }

    public FileSystem mkdirBlocking(String path, String perms) {
        this.delegate.mkdirBlocking(path, perms);
        return this;
    }

    public FileSystem mkdirs(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdirs(path, handler);
        return this;
    }

    public Observable<Void> mkdirsObservable(String path) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.mkdirs(path, handler.toHandler());
        return handler;
    }

    public FileSystem mkdirsBlocking(String path) {
        this.delegate.mkdirsBlocking(path);
        return this;
    }

    public FileSystem mkdirs(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.mkdirs(path, perms, handler);
        return this;
    }

    public Observable<Void> mkdirsObservable(String path, String perms) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.mkdirs(path, perms, handler.toHandler());
        return handler;
    }

    public FileSystem mkdirsBlocking(String path, String perms) {
        this.delegate.mkdirsBlocking(path, perms);
        return this;
    }

    public FileSystem readDir(String path, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.readDir(path, handler);
        return this;
    }

    public Observable<List<String>> readDirObservable(String path) {
        ObservableFuture<List<String>> handler = RxHelper.observableFuture();
        this.readDir(path, handler.toHandler());
        return handler;
    }

    public List<String> readDirBlocking(String path) {
        List ret = this.delegate.readDirBlocking(path);
        return ret;
    }

    public FileSystem readDir(String path, String filter, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.readDir(path, filter, handler);
        return this;
    }

    public Observable<List<String>> readDirObservable(String path, String filter) {
        ObservableFuture<List<String>> handler = RxHelper.observableFuture();
        this.readDir(path, filter, handler.toHandler());
        return handler;
    }

    public List<String> readDirBlocking(String path, String filter) {
        List ret = this.delegate.readDirBlocking(path, filter);
        return ret;
    }

    public FileSystem readFile(String path, final Handler<AsyncResult<Buffer>> handler) {
        this.delegate.readFile(path, (Handler)new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>(){

            public void handle(AsyncResult<io.vertx.core.buffer.Buffer> event) {
                Object f = event.succeeded() ? InternalHelper.result(new Buffer((io.vertx.core.buffer.Buffer)event.result())) : InternalHelper.failure(event.cause());
                handler.handle(f);
            }
        });
        return this;
    }

    public Observable<Buffer> readFileObservable(String path) {
        ObservableFuture<Buffer> handler = RxHelper.observableFuture();
        this.readFile(path, handler.toHandler());
        return handler;
    }

    public Buffer readFileBlocking(String path) {
        Buffer ret = Buffer.newInstance(this.delegate.readFileBlocking(path));
        return ret;
    }

    public FileSystem writeFile(String path, Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFile(path, (io.vertx.core.buffer.Buffer)data.getDelegate(), handler);
        return this;
    }

    public Observable<Void> writeFileObservable(String path, Buffer data) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.writeFile(path, data, handler.toHandler());
        return handler;
    }

    public FileSystem writeFileBlocking(String path, Buffer data) {
        this.delegate.writeFileBlocking(path, (io.vertx.core.buffer.Buffer)data.getDelegate());
        return this;
    }

    public FileSystem open(String path, OpenOptions options, final Handler<AsyncResult<AsyncFile>> handler) {
        this.delegate.open(path, options, (Handler)new Handler<AsyncResult<io.vertx.core.file.AsyncFile>>(){

            public void handle(AsyncResult<io.vertx.core.file.AsyncFile> event) {
                Object f = event.succeeded() ? InternalHelper.result(new AsyncFile((io.vertx.core.file.AsyncFile)event.result())) : InternalHelper.failure(event.cause());
                handler.handle(f);
            }
        });
        return this;
    }

    public Observable<AsyncFile> openObservable(String path, OpenOptions options) {
        ObservableFuture<AsyncFile> handler = RxHelper.observableFuture();
        this.open(path, options, handler.toHandler());
        return handler;
    }

    public AsyncFile openBlocking(String path, OpenOptions options) {
        AsyncFile ret = AsyncFile.newInstance(this.delegate.openBlocking(path, options));
        return ret;
    }

    public FileSystem createFile(String path, Handler<AsyncResult<Void>> handler) {
        this.delegate.createFile(path, handler);
        return this;
    }

    public Observable<Void> createFileObservable(String path) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.createFile(path, handler.toHandler());
        return handler;
    }

    public FileSystem createFileBlocking(String path) {
        this.delegate.createFileBlocking(path);
        return this;
    }

    public FileSystem createFile(String path, String perms, Handler<AsyncResult<Void>> handler) {
        this.delegate.createFile(path, perms, handler);
        return this;
    }

    public Observable<Void> createFileObservable(String path, String perms) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.createFile(path, perms, handler.toHandler());
        return handler;
    }

    public FileSystem createFileBlocking(String path, String perms) {
        this.delegate.createFileBlocking(path, perms);
        return this;
    }

    public FileSystem exists(String path, Handler<AsyncResult<Boolean>> handler) {
        this.delegate.exists(path, handler);
        return this;
    }

    public Observable<Boolean> existsObservable(String path) {
        ObservableFuture<Boolean> handler = RxHelper.observableFuture();
        this.exists(path, handler.toHandler());
        return handler;
    }

    public boolean existsBlocking(String path) {
        boolean ret = this.delegate.existsBlocking(path);
        return ret;
    }

    public FileSystem fsProps(String path, final Handler<AsyncResult<FileSystemProps>> handler) {
        this.delegate.fsProps(path, (Handler)new Handler<AsyncResult<io.vertx.core.file.FileSystemProps>>(){

            public void handle(AsyncResult<io.vertx.core.file.FileSystemProps> event) {
                Object f = event.succeeded() ? InternalHelper.result(new FileSystemProps((io.vertx.core.file.FileSystemProps)event.result())) : InternalHelper.failure(event.cause());
                handler.handle(f);
            }
        });
        return this;
    }

    public Observable<FileSystemProps> fsPropsObservable(String path) {
        ObservableFuture<FileSystemProps> handler = RxHelper.observableFuture();
        this.fsProps(path, handler.toHandler());
        return handler;
    }

    public FileSystemProps fsPropsBlocking(String path) {
        FileSystemProps ret = FileSystemProps.newInstance(this.delegate.fsPropsBlocking(path));
        return ret;
    }

    public static FileSystem newInstance(io.vertx.core.file.FileSystem arg) {
        return arg != null ? new FileSystem(arg) : null;
    }
}

