/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.InternalHelper;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.http.HttpServerRequest;
import io.vertx.rxjava.core.http.HttpServerRequestStream;
import io.vertx.rxjava.core.http.ServerWebSocket;
import io.vertx.rxjava.core.http.ServerWebSocketStream;
import io.vertx.rxjava.core.metrics.Measured;
import rx.Observable;

public class HttpServer
implements Measured {
    final io.vertx.core.http.HttpServer delegate;

    public HttpServer(io.vertx.core.http.HttpServer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public HttpServerRequestStream requestStream() {
        HttpServerRequestStream ret = HttpServerRequestStream.newInstance(this.delegate.requestStream());
        return ret;
    }

    public HttpServer requestHandler(final Handler<HttpServerRequest> handler) {
        HttpServer ret = HttpServer.newInstance(this.delegate.requestHandler((Handler)new Handler<io.vertx.core.http.HttpServerRequest>(){

            public void handle(io.vertx.core.http.HttpServerRequest event) {
                handler.handle((Object)new HttpServerRequest(event));
            }
        }));
        return ret;
    }

    public ServerWebSocketStream websocketStream() {
        ServerWebSocketStream ret = ServerWebSocketStream.newInstance(this.delegate.websocketStream());
        return ret;
    }

    public HttpServer websocketHandler(final Handler<ServerWebSocket> handler) {
        HttpServer ret = HttpServer.newInstance(this.delegate.websocketHandler((Handler)new Handler<io.vertx.core.http.ServerWebSocket>(){

            public void handle(io.vertx.core.http.ServerWebSocket event) {
                handler.handle((Object)new ServerWebSocket(event));
            }
        }));
        return ret;
    }

    public HttpServer listen() {
        this.delegate.listen();
        return this;
    }

    public HttpServer listen(int port, String host) {
        this.delegate.listen(port, host);
        return this;
    }

    public HttpServer listen(int port, String host, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> event) {
                Object f = event.succeeded() ? InternalHelper.result(new HttpServer((io.vertx.core.http.HttpServer)event.result())) : InternalHelper.failure(event.cause());
                listenHandler.handle(f);
            }
        });
        return this;
    }

    public Observable<HttpServer> listenObservable(int port, String host) {
        ObservableFuture<HttpServer> listenHandler = RxHelper.observableFuture();
        this.listen(port, host, listenHandler.toHandler());
        return listenHandler;
    }

    public HttpServer listen(int port) {
        this.delegate.listen(port);
        return this;
    }

    public HttpServer listen(int port, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> event) {
                Object f = event.succeeded() ? InternalHelper.result(new HttpServer((io.vertx.core.http.HttpServer)event.result())) : InternalHelper.failure(event.cause());
                listenHandler.handle(f);
            }
        });
        return this;
    }

    public Observable<HttpServer> listenObservable(int port) {
        ObservableFuture<HttpServer> listenHandler = RxHelper.observableFuture();
        this.listen(port, listenHandler.toHandler());
        return listenHandler;
    }

    public HttpServer listen(final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen((Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> event) {
                Object f = event.succeeded() ? InternalHelper.result(new HttpServer((io.vertx.core.http.HttpServer)event.result())) : InternalHelper.failure(event.cause());
                listenHandler.handle(f);
            }
        });
        return this;
    }

    public Observable<HttpServer> listenObservable() {
        ObservableFuture<HttpServer> listenHandler = RxHelper.observableFuture();
        this.listen(listenHandler.toHandler());
        return listenHandler;
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public Observable<Void> closeObservable() {
        ObservableFuture<Void> completionHandler = RxHelper.observableFuture();
        this.close(completionHandler.toHandler());
        return completionHandler;
    }

    public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
        return arg != null ? new HttpServer(arg) : null;
    }
}

