/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.Future;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.streams.WriteStream;
import rx.Observable;

public class HttpServerResponse
implements WriteStream<Buffer> {
    final io.vertx.core.http.HttpServerResponse delegate;
    private MultiMap cached_0;
    private MultiMap cached_1;

    public HttpServerResponse(io.vertx.core.http.HttpServerResponse delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServerResponse write(Buffer data) {
        this.delegate.write((io.vertx.core.buffer.Buffer)data.getDelegate());
        return this;
    }

    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpServerResponse drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public int getStatusCode() {
        int ret = this.delegate.getStatusCode();
        return ret;
    }

    public HttpServerResponse setStatusCode(int statusCode) {
        this.delegate.setStatusCode(statusCode);
        return this;
    }

    public String getStatusMessage() {
        String ret = this.delegate.getStatusMessage();
        return ret;
    }

    public HttpServerResponse setStatusMessage(String statusMessage) {
        this.delegate.setStatusMessage(statusMessage);
        return this;
    }

    public HttpServerResponse setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpServerResponse putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public MultiMap trailers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.trailers());
        return ret;
    }

    public HttpServerResponse putTrailer(String name, String value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public HttpServerResponse closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public HttpServerResponse write(String chunk, String enc) {
        this.delegate.write(chunk, enc);
        return this;
    }

    public HttpServerResponse write(String chunk) {
        this.delegate.write(chunk);
        return this;
    }

    public void end(String chunk) {
        this.delegate.end(chunk);
    }

    public void end(String chunk, String enc) {
        this.delegate.end(chunk, enc);
    }

    public void end(Buffer chunk) {
        this.delegate.end((io.vertx.core.buffer.Buffer)chunk.getDelegate());
    }

    public void end() {
        this.delegate.end();
    }

    public HttpServerResponse sendFile(String filename) {
        this.delegate.sendFile(filename);
        return this;
    }

    public HttpServerResponse sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, resultHandler);
        return this;
    }

    public Observable<Void> sendFileObservable(String filename) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.sendFile(filename, resultHandler.toHandler());
        return resultHandler;
    }

    public void close() {
        this.delegate.close();
    }

    public boolean ended() {
        boolean ret = this.delegate.ended();
        return ret;
    }

    public boolean headWritten() {
        boolean ret = this.delegate.headWritten();
        return ret;
    }

    public HttpServerResponse headersEndHandler(final Handler<Future> handler) {
        this.delegate.headersEndHandler((Handler)new Handler<io.vertx.core.Future>(){

            public void handle(io.vertx.core.Future event) {
                handler.handle(new Future(event));
            }
        });
        return this;
    }

    public HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        this.delegate.bodyEndHandler(handler);
        return this;
    }

    public static HttpServerResponse newInstance(io.vertx.core.http.HttpServerResponse arg) {
        return arg != null ? new HttpServerResponse(arg) : null;
    }
}

