/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import java.util.function.Function;
import rx.Observable;

public class Future<T> {
    final io.vertx.core.Future delegate;
    private Handler<AsyncResult<T>> cached_0;

    public Future(io.vertx.core.Future delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public static <T> Future<T> future() {
        Future ret = Future.newInstance(io.vertx.core.Future.future());
        return ret;
    }

    public static <T> Future<T> succeededFuture() {
        Future ret = Future.newInstance(io.vertx.core.Future.succeededFuture());
        return ret;
    }

    public static <T> Future<T> succeededFuture(T result) {
        Future ret = Future.newInstance(io.vertx.core.Future.succeededFuture(result));
        return ret;
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        Future ret = Future.newInstance(io.vertx.core.Future.failedFuture((String)failureMessage));
        return ret;
    }

    public boolean isComplete() {
        boolean ret = this.delegate.isComplete();
        return ret;
    }

    public Future<T> setHandler(Handler<AsyncResult<T>> handler) {
        this.delegate.setHandler(handler);
        return this;
    }

    public Observable<T> setHandlerObservable() {
        ObservableFuture handler = RxHelper.observableFuture();
        this.setHandler(handler.toHandler());
        return handler;
    }

    public void complete(T result) {
        this.delegate.complete(result);
    }

    public void complete() {
        this.delegate.complete();
    }

    public void fail(Throwable throwable) {
        this.delegate.fail(throwable);
    }

    public void fail(String failureMessage) {
        this.delegate.fail(failureMessage);
    }

    public T result() {
        Object ret = this.delegate.result();
        return (T)ret;
    }

    public Throwable cause() {
        Throwable ret = this.delegate.cause();
        return ret;
    }

    public boolean succeeded() {
        boolean ret = this.delegate.succeeded();
        return ret;
    }

    public boolean failed() {
        boolean ret = this.delegate.failed();
        return ret;
    }

    public <U> Future<U> compose(Handler<T> handler, Future<U> next) {
        Future ret = Future.newInstance(this.delegate.compose(handler, (io.vertx.core.Future)next.getDelegate()));
        return ret;
    }

    public <U> Future<U> compose(final Function<T, Future<U>> mapper) {
        Future ret = Future.newInstance(this.delegate.compose(new Function<T, io.vertx.core.Future<U>>(){

            @Override
            public io.vertx.core.Future<U> apply(T arg) {
                Future ret = (Future)mapper.apply(arg);
                return (io.vertx.core.Future)ret.getDelegate();
            }
        }));
        return ret;
    }

    public <U> Future<U> map(final Function<T, U> mapper) {
        Future ret = Future.newInstance(this.delegate.map(new Function<T, U>(){

            @Override
            public U apply(T arg) {
                Object ret = mapper.apply(arg);
                return ret;
            }
        }));
        return ret;
    }

    public <V> Future<V> map(V value) {
        Future ret = Future.newInstance(this.delegate.map(value));
        return ret;
    }

    public Handler<AsyncResult<T>> completer() {
        Handler ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = new Handler<AsyncResult<T>>(){

            public void handle(AsyncResult<T> ar) {
                if (ar.succeeded()) {
                    Future.this.delegate.completer().handle((Object)io.vertx.core.Future.succeededFuture((Object)ar.result()));
                } else {
                    Future.this.delegate.completer().handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        };
        return ret;
    }

    public static <T> Future newInstance(io.vertx.core.Future arg) {
        return arg != null ? new Future<T>(arg) : null;
    }
}

