/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.rx.java.ContextScheduler;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.UnmarshallerOperator;
import io.vertx.rxjava.core.Context;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.http.HttpClient;
import io.vertx.rxjava.core.http.HttpClientRequest;
import io.vertx.rxjava.core.http.HttpClientResponse;
import rx.Observable;
import rx.Scheduler;
import rx.plugins.RxJavaSchedulersHook;

public class RxHelper {
    public static RxJavaSchedulersHook schedulerHook(Vertx vertx) {
        return io.vertx.rx.java.RxHelper.schedulerHook(vertx.delegate);
    }

    public static RxJavaSchedulersHook schedulerHook(Context context) {
        return io.vertx.rx.java.RxHelper.schedulerHook(context.delegate);
    }

    public static Scheduler scheduler(Vertx vertx) {
        return new ContextScheduler(vertx.delegate, false);
    }

    public static Scheduler scheduler(Context context) {
        return new ContextScheduler(context.delegate, false);
    }

    public static Scheduler blockingScheduler(Vertx vertx) {
        return new ContextScheduler(vertx.delegate.getOrCreateContext(), true);
    }

    public static <T> Observable.Operator<T, Buffer> unmarshaller(Class<T> mappedType) {
        return new UnmarshallerOperator<T, Buffer>((Class)mappedType){

            @Override
            public io.vertx.core.buffer.Buffer unwrap(Buffer buffer) {
                return (io.vertx.core.buffer.Buffer)buffer.getDelegate();
            }
        };
    }

    public static Observable<HttpClientResponse> get(HttpClient client, String requestURI) {
        return Observable.create(subscriber -> {
            HttpClientRequest req = client.get(requestURI);
            Observable<HttpClientResponse> resp = req.toObservable();
            resp.subscribe(subscriber);
            req.end();
        });
    }

    public static Observable<HttpClientResponse> get(HttpClient client, String host, String requestURI) {
        return Observable.create(subscriber -> {
            HttpClientRequest req = client.get(host, requestURI);
            Observable<HttpClientResponse> resp = req.toObservable();
            resp.subscribe(subscriber);
            req.end();
        });
    }

    public static Observable<HttpClientResponse> get(HttpClient client, int port, String host, String requestURI) {
        return Observable.create(subscriber -> {
            HttpClientRequest req = client.get(port, host, requestURI);
            Observable<HttpClientResponse> resp = req.toObservable();
            resp.subscribe(subscriber);
            req.end();
        });
    }

    public static Observable<HttpClientResponse> get(HttpClient client, int port, String host, String requestURI, MultiMap headers) {
        return Observable.create(subscriber -> {
            HttpClientRequest req = client.get(port, host, requestURI);
            req.headers().addAll(headers);
            Observable<HttpClientResponse> resp = req.toObservable();
            resp.subscribe(subscriber);
            req.end();
        });
    }

    public static Observable<String> deployVerticle(Vertx vertx, Verticle verticle) {
        return RxHelper.deployVerticle(vertx, verticle, new DeploymentOptions());
    }

    public static Observable<String> deployVerticle(Vertx vertx, Verticle verticle, DeploymentOptions options) {
        ObservableFuture<String> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
        ((io.vertx.core.Vertx)vertx.getDelegate()).deployVerticle(verticle, options, completionHandler.toHandler());
        return completionHandler;
    }
}

