/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.lang.rxjava.ReadStreamAdapter;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.http.HttpClientResponse;
import io.vertx.rxjava.core.http.HttpConnection;
import io.vertx.rxjava.core.http.HttpFrame;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;

public class HttpClientRequest
implements WriteStream<Buffer>,
ReadStream<HttpClientResponse> {
    final io.vertx.core.http.HttpClientRequest delegate;
    private Observable<HttpClientResponse> observable;
    private MultiMap cached_0;
    private HttpConnection cached_1;

    public HttpClientRequest(io.vertx.core.http.HttpClientRequest delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<HttpClientResponse> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.http.HttpClientResponse, HttpClientResponse> conv = HttpClientResponse::newInstance;
            ReadStreamAdapter<io.vertx.core.http.HttpClientResponse, HttpClientResponse> adapter = new ReadStreamAdapter<io.vertx.core.http.HttpClientResponse, HttpClientResponse>(this, conv);
            this.observable = Observable.create(adapter);
        }
        return this.observable;
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpClientRequest write(Buffer data) {
        this.delegate.write((io.vertx.core.buffer.Buffer)data.getDelegate());
        return this;
    }

    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpClientRequest drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public HttpClientRequest handler(final Handler<HttpClientResponse> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.http.HttpClientResponse>(){

            public void handle(io.vertx.core.http.HttpClientResponse event) {
                handler.handle((Object)HttpClientResponse.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientRequest pause() {
        this.delegate.pause();
        return this;
    }

    public HttpClientRequest resume() {
        this.delegate.resume();
        return this;
    }

    public HttpClientRequest endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public HttpClientRequest setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public HttpMethod method() {
        HttpMethod ret = this.delegate.method();
        return ret;
    }

    public String getRawMethod() {
        String ret = this.delegate.getRawMethod();
        return ret;
    }

    public HttpClientRequest setRawMethod(String method) {
        this.delegate.setRawMethod(method);
        return this;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public HttpClientRequest setHost(String host) {
        this.delegate.setHost(host);
        return this;
    }

    public String getHost() {
        String ret = this.delegate.getHost();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public HttpClientRequest putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpClientRequest write(String chunk) {
        this.delegate.write(chunk);
        return this;
    }

    public HttpClientRequest write(String chunk, String enc) {
        this.delegate.write(chunk, enc);
        return this;
    }

    public HttpClientRequest continueHandler(Handler<Void> handler) {
        this.delegate.continueHandler(handler);
        return this;
    }

    public HttpClientRequest sendHead() {
        this.delegate.sendHead();
        return this;
    }

    public HttpClientRequest sendHead(Handler<HttpVersion> completionHandler) {
        this.delegate.sendHead(completionHandler);
        return this;
    }

    @Override
    public void end(String chunk) {
        this.delegate.end(chunk);
    }

    public void end(String chunk, String enc) {
        this.delegate.end(chunk, enc);
    }

    @Override
    public void end(Buffer chunk) {
        this.delegate.end((io.vertx.core.buffer.Buffer)chunk.getDelegate());
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    public HttpClientRequest setTimeout(long timeoutMs) {
        this.delegate.setTimeout(timeoutMs);
        return this;
    }

    public HttpClientRequest pushHandler(final Handler<HttpClientRequest> handler) {
        this.delegate.pushHandler((Handler)new Handler<io.vertx.core.http.HttpClientRequest>(){

            public void handle(io.vertx.core.http.HttpClientRequest event) {
                handler.handle((Object)HttpClientRequest.newInstance(event));
            }
        });
        return this;
    }

    public void reset() {
        this.delegate.reset();
    }

    public void reset(long code) {
        this.delegate.reset(code);
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public HttpClientRequest connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new Handler<io.vertx.core.http.HttpConnection>(){

            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle((Object)HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
        this.delegate.writeCustomFrame(type, flags, (io.vertx.core.buffer.Buffer)payload.getDelegate());
        return this;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public HttpClientRequest writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame((io.vertx.core.http.HttpFrame)frame.getDelegate());
        return this;
    }

    public static HttpClientRequest newInstance(io.vertx.core.http.HttpClientRequest arg) {
        return arg != null ? new HttpClientRequest(arg) : null;
    }
}

