/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.net;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.ReadStreamAdapter;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.net.SocketAddress;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;

public class NetSocket
implements ReadStream<Buffer>,
WriteStream<Buffer> {
    final io.vertx.core.net.NetSocket delegate;
    private Observable<Buffer> observable;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public NetSocket(io.vertx.core.net.NetSocket delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            ReadStreamAdapter<io.vertx.core.buffer.Buffer, Buffer> adapter = new ReadStreamAdapter<io.vertx.core.buffer.Buffer, Buffer>(this, conv);
            this.observable = Observable.create(adapter);
        }
        return this.observable;
    }

    @Override
    public void end(Buffer t) {
        this.delegate.end((Object)((io.vertx.core.buffer.Buffer)t.getDelegate()));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public NetSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public NetSocket handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    public NetSocket pause() {
        this.delegate.pause();
        return this;
    }

    public NetSocket resume() {
        this.delegate.resume();
        return this;
    }

    public NetSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public NetSocket write(Buffer data) {
        this.delegate.write((Object)((io.vertx.core.buffer.Buffer)data.getDelegate()));
        return this;
    }

    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public NetSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public String writeHandlerID() {
        String ret = this.delegate.writeHandlerID();
        return ret;
    }

    public NetSocket write(String str) {
        this.delegate.write(str);
        return this;
    }

    public NetSocket write(String str, String enc) {
        this.delegate.write(str, enc);
        return this;
    }

    public NetSocket sendFile(String filename) {
        this.delegate.sendFile(filename);
        return this;
    }

    public NetSocket sendFile(String filename, long offset) {
        this.delegate.sendFile(filename, offset);
        return this;
    }

    public NetSocket sendFile(String filename, long offset, long length) {
        this.delegate.sendFile(filename, offset, length);
        return this;
    }

    public NetSocket sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, resultHandler);
        return this;
    }

    public Observable<Void> sendFileObservable(String filename) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.sendFile(filename, resultHandler.toHandler());
        return resultHandler;
    }

    public NetSocket sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, resultHandler);
        return this;
    }

    public Observable<Void> sendFileObservable(String filename, long offset) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.sendFile(filename, offset, resultHandler.toHandler());
        return resultHandler;
    }

    public NetSocket sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, length, resultHandler);
        return this;
    }

    public Observable<Void> sendFileObservable(String filename, long offset, long length) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.sendFile(filename, offset, length, resultHandler.toHandler());
        return resultHandler;
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    public void close() {
        this.delegate.close();
    }

    public NetSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public NetSocket upgradeToSsl(Handler<Void> handler) {
        this.delegate.upgradeToSsl(handler);
        return this;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public static NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
        return arg != null ? new NetSocket(arg) : null;
    }
}

