/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An executor for executing blocking code in Vert.x .<p>
 *
 * It provides the same <code>executeBlocking</code> operation than {@link io.vertx.rxjava.core.Context} and
 * {@link io.vertx.rxjava.core.Vertx} but on a separate worker pool.<p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.WorkerExecutor original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.WorkerExecutor.class)
public class WorkerExecutor implements Measured {

  public static final io.vertx.lang.rxjava.TypeArg<WorkerExecutor> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new WorkerExecutor((io.vertx.core.WorkerExecutor) obj),
    WorkerExecutor::getDelegate
  );

  private final io.vertx.core.WorkerExecutor delegate;
  
  public WorkerExecutor(io.vertx.core.WorkerExecutor delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.WorkerExecutor getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return true if the metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (i.e. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.rxjava.core.Future#complete} or {@link io.vertx.rxjava.core.Future#complete} method, or the {@link io.vertx.rxjava.core.Future#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @param resultHandler handler that will be called when the blocking code is complete
   */
  public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>() {
      public void handle(io.vertx.core.Future<T> event) {
        blockingCodeHandler.handle(Future.newInstance(event, io.vertx.lang.rxjava.TypeArg.unknown()));
      }
    }, ordered, new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((T) ar.result()));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (i.e. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.rxjava.core.Future#complete} or {@link io.vertx.rxjava.core.Future#complete} method, or the {@link io.vertx.rxjava.core.Future#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return 
   * @deprecated use {@link #rxExecuteBlocking} instead
   */
  @Deprecated()
  public <T> Observable<T> executeBlockingObservable(Handler<Future<T>> blockingCodeHandler, boolean ordered) { 
    io.vertx.rx.java.ObservableFuture<T> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    executeBlocking(blockingCodeHandler, ordered, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (i.e. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.rxjava.core.Future#complete} or {@link io.vertx.rxjava.core.Future#complete} method, or the {@link io.vertx.rxjava.core.Future#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return 
   */
  public <T> Single<T> rxExecuteBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      executeBlocking(blockingCodeHandler, ordered, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.WorkerExecutor#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @param resultHandler 
   */
  public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>() {
      public void handle(io.vertx.core.Future<T> event) {
        blockingCodeHandler.handle(Future.newInstance(event, io.vertx.lang.rxjava.TypeArg.unknown()));
      }
    }, new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((T) ar.result()));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.rxjava.core.WorkerExecutor#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   * @deprecated use {@link #rxExecuteBlocking} instead
   */
  @Deprecated()
  public <T> Observable<T> executeBlockingObservable(Handler<Future<T>> blockingCodeHandler) { 
    io.vertx.rx.java.ObservableFuture<T> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    executeBlocking(blockingCodeHandler, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.WorkerExecutor#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   */
  public <T> Single<T> rxExecuteBlocking(Handler<Future<T>> blockingCodeHandler) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      executeBlocking(blockingCodeHandler, fut);
    }));
  }

  /**
   * Close the executor.
   */
  public void close() { 
    delegate.close();
  }


  public static WorkerExecutor newInstance(io.vertx.core.WorkerExecutor arg) {
    return arg != null ? new WorkerExecutor(arg) : null;
  }
}
