/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.metrics;

import java.util.Map;
import rx.Observable;
import rx.Single;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.metrics.Measured original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.metrics.Measured.class)
public interface Measured {

  io.vertx.core.metrics.Measured getDelegate();

  /**
   * Whether the metrics are enabled for this measured object
   * @return true if the metrics are enabled
   */
  public boolean isMetricsEnabled();


  public static Measured newInstance(io.vertx.core.metrics.Measured arg) {
    return arg != null ? new MeasuredImpl(arg) : null;
  }
}

class MeasuredImpl implements Measured {
  private final io.vertx.core.metrics.Measured delegate;
  
  public MeasuredImpl(io.vertx.core.metrics.Measured delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.metrics.Measured getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return true if the metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

}
