/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.net;

import java.util.Map;
import rx.Observable;
import rx.Single;

/**
 * The address of a socket
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.SocketAddress original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.net.SocketAddress.class)
public class SocketAddress {

  public static final io.vertx.lang.rxjava.TypeArg<SocketAddress> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new SocketAddress((io.vertx.core.net.SocketAddress) obj),
    SocketAddress::getDelegate
  );

  private final io.vertx.core.net.SocketAddress delegate;
  
  public SocketAddress(io.vertx.core.net.SocketAddress delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.net.SocketAddress getDelegate() {
    return delegate;
  }

  public String host() { 
    String ret = delegate.host();
    return ret;
  }

  public int port() { 
    int ret = delegate.port();
    return ret;
  }


  public static SocketAddress newInstance(io.vertx.core.net.SocketAddress arg) {
    return arg != null ? new SocketAddress(arg) : null;
  }
}
