/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.shareddata;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An asynchronous counter that can be used to across the cluster to maintain a consistent count.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.Counter original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.shareddata.Counter.class)
public class Counter {

  public static final io.vertx.lang.rxjava.TypeArg<Counter> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new Counter((io.vertx.core.shareddata.Counter) obj),
    Counter::getDelegate
  );

  private final io.vertx.core.shareddata.Counter delegate;
  
  public Counter(io.vertx.core.shareddata.Counter delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.shareddata.Counter getDelegate() {
    return delegate;
  }

  /**
   * Get the current value of the counter
   * @param resultHandler handler which will be passed the value
   */
  public void get(Handler<AsyncResult<Long>> resultHandler) { 
    delegate.get(resultHandler);
  }

  /**
   * Get the current value of the counter
   * @return 
   * @deprecated use {@link #rxGet} instead
   */
  @Deprecated()
  public Observable<Long> getObservable() { 
    io.vertx.rx.java.ObservableFuture<Long> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    get(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Get the current value of the counter
   * @return 
   */
  public Single<Long> rxGet() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      get(fut);
    }));
  }

  /**
   * Increment the counter atomically and return the new count
   * @param resultHandler handler which will be passed the value
   */
  public void incrementAndGet(Handler<AsyncResult<Long>> resultHandler) { 
    delegate.incrementAndGet(resultHandler);
  }

  /**
   * Increment the counter atomically and return the new count
   * @return 
   * @deprecated use {@link #rxIncrementAndGet} instead
   */
  @Deprecated()
  public Observable<Long> incrementAndGetObservable() { 
    io.vertx.rx.java.ObservableFuture<Long> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    incrementAndGet(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Increment the counter atomically and return the new count
   * @return 
   */
  public Single<Long> rxIncrementAndGet() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      incrementAndGet(fut);
    }));
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @param resultHandler handler which will be passed the value
   */
  public void getAndIncrement(Handler<AsyncResult<Long>> resultHandler) { 
    delegate.getAndIncrement(resultHandler);
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @return 
   * @deprecated use {@link #rxGetAndIncrement} instead
   */
  @Deprecated()
  public Observable<Long> getAndIncrementObservable() { 
    io.vertx.rx.java.ObservableFuture<Long> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    getAndIncrement(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Increment the counter atomically and return the value before the increment.
   * @return 
   */
  public Single<Long> rxGetAndIncrement() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getAndIncrement(fut);
    }));
  }

  /**
   * Decrement the counter atomically and return the new count
   * @param resultHandler handler which will be passed the value
   */
  public void decrementAndGet(Handler<AsyncResult<Long>> resultHandler) { 
    delegate.decrementAndGet(resultHandler);
  }

  /**
   * Decrement the counter atomically and return the new count
   * @return 
   * @deprecated use {@link #rxDecrementAndGet} instead
   */
  @Deprecated()
  public Observable<Long> decrementAndGetObservable() { 
    io.vertx.rx.java.ObservableFuture<Long> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    decrementAndGet(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Decrement the counter atomically and return the new count
   * @return 
   */
  public Single<Long> rxDecrementAndGet() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      decrementAndGet(fut);
    }));
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @param resultHandler handler which will be passed the value
   */
  public void addAndGet(long value, Handler<AsyncResult<Long>> resultHandler) { 
    delegate.addAndGet(value, resultHandler);
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @return 
   * @deprecated use {@link #rxAddAndGet} instead
   */
  @Deprecated()
  public Observable<Long> addAndGetObservable(long value) { 
    io.vertx.rx.java.ObservableFuture<Long> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    addAndGet(value, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Add the value to the counter atomically and return the new count
   * @param value the value to add
   * @return 
   */
  public Single<Long> rxAddAndGet(long value) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      addAndGet(value, fut);
    }));
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @param resultHandler handler which will be passed the value
   */
  public void getAndAdd(long value, Handler<AsyncResult<Long>> resultHandler) { 
    delegate.getAndAdd(value, resultHandler);
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @return 
   * @deprecated use {@link #rxGetAndAdd} instead
   */
  @Deprecated()
  public Observable<Long> getAndAddObservable(long value) { 
    io.vertx.rx.java.ObservableFuture<Long> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    getAndAdd(value, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Add the value to the counter atomically and return the value before the add
   * @param value the value to add
   * @return 
   */
  public Single<Long> rxGetAndAdd(long value) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getAndAdd(value, fut);
    }));
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @param resultHandler the handler will be passed true on success
   */
  public void compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.compareAndSet(expected, value, resultHandler);
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @return 
   * @deprecated use {@link #rxCompareAndSet} instead
   */
  @Deprecated()
  public Observable<Boolean> compareAndSetObservable(long expected, long value) { 
    io.vertx.rx.java.ObservableFuture<Boolean> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    compareAndSet(expected, value, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Set the counter to the specified value only if the current value is the expectec value. This happens
   * atomically.
   * @param expected the expected value
   * @param value the new value
   * @return 
   */
  public Single<Boolean> rxCompareAndSet(long expected, long value) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      compareAndSet(expected, value, fut);
    }));
  }


  public static Counter newInstance(io.vertx.core.shareddata.Counter arg) {
    return arg != null ? new Counter(arg) : null;
  }
}
