/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.streams;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.core.Handler;

/**
 * Base interface for a stream.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.streams.StreamBase original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.streams.StreamBase.class)
public interface StreamBase {

  io.vertx.core.streams.StreamBase getDelegate();

  /**
   * Set an exception handler.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public StreamBase exceptionHandler(Handler<Throwable> handler);


  public static StreamBase newInstance(io.vertx.core.streams.StreamBase arg) {
    return arg != null ? new StreamBaseImpl(arg) : null;
  }
}

class StreamBaseImpl implements StreamBase {
  private final io.vertx.core.streams.StreamBase delegate;
  
  public StreamBaseImpl(io.vertx.core.streams.StreamBase delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.streams.StreamBase getDelegate() {
    return delegate;
  }

  /**
   * Set an exception handler.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public StreamBase exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

}
