/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core;

import java.util.Map;
import rx.Observable;
import rx.Single;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 * The composite future wraps a list of {@link io.vertx.rxjava.core.Future futures}, it is useful when several futures
 * needs to be coordinated.
 * The handlers set for the coordinated futures are overridden by the handler of the composite future.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.CompositeFuture original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.CompositeFuture.class)
public class CompositeFuture extends Future<CompositeFuture> {

  public static final io.vertx.lang.rxjava.TypeArg<CompositeFuture> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new CompositeFuture((io.vertx.core.CompositeFuture) obj),
    CompositeFuture::getDelegate
  );

  private final io.vertx.core.CompositeFuture delegate;
  
  public CompositeFuture(io.vertx.core.CompositeFuture delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.core.CompositeFuture getDelegate() {
    return delegate;
  }

  /**
   * Set the result. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param result the result
   */
  public void complete(CompositeFuture result) { 
    delegate.complete(result.getDelegate());
  }

  /**
   * Set the failure. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param result the result
   * @return false when the future is already completed
   */
  public boolean tryComplete(CompositeFuture result) { 
    boolean ret = delegate.tryComplete(result.getDelegate());
    return ret;
  }

  /**
   * The result of the operation. This will be null if the operation failed.
   * @return the result or null if the operation failed.
   */
  public CompositeFuture result() { 
    CompositeFuture ret = CompositeFuture.newInstance(delegate.result());
    return ret;
  }

  /**
   * Compose this future with a provided <code>next</code> future.<p>
   *
   * When this (the one on which <code>compose</code> is called) future succeeds, the <code>handler</code> will be called with
   * the completed value, this handler should complete the next future.<p>
   *
   * If the <code>handler</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future fails, the failure will be propagated to the <code>next</code> future and the <code>handler</code>
   * will not be called.
   * @param handler the handler
   * @param next the next future
   * @return the next future, used for chaining
   */
  public <U> Future<U> compose(Handler<CompositeFuture> handler, Future<U> next) { 
    Future<U> ret = Future.newInstance(delegate.compose(new Handler<io.vertx.core.CompositeFuture>() {
      public void handle(io.vertx.core.CompositeFuture event) {
        handler.handle(CompositeFuture.newInstance(event));
      }
    }, next.getDelegate()), next.__typeArg_0);
    return ret;
  }

  /**
   * Compose this future with a <code>mapper</code> function.<p>
   *
   * When this future (the one on which <code>compose</code> is called) succeeds, the <code>mapper</code> will be called with
   * the completed value and this mapper returns another future object. This returned future completion will complete
   * the future returned by this method call.<p>
   *
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the composed future
   */
  public <U> Future<U> compose(Function<CompositeFuture,Future<U>> mapper) { 
    Future<U> ret = Future.newInstance(delegate.compose(new java.util.function.Function<io.vertx.core.CompositeFuture,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(io.vertx.core.CompositeFuture arg) {
        Future<U> ret = mapper.apply(CompositeFuture.newInstance(arg));
        return ret.getDelegate();
      }
    }), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Apply a <code>mapper</code> function on this future.<p>
   *
   * When this future succeeds, the <code>mapper</code> will be called with the completed value and this mapper
   * returns a value. This value will complete the future returned by this method call.<p>
   *
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the mapped future
   */
  public <U> Future<U> map(Function<CompositeFuture,U> mapper) { 
    Future<U> ret = Future.newInstance(delegate.map(new java.util.function.Function<io.vertx.core.CompositeFuture,U>() {
      public U apply(io.vertx.core.CompositeFuture arg) {
        U ret = mapper.apply(CompositeFuture.newInstance(arg));
        return ret;
      }
    }), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * @return an handler completing this future
   */
  public Handler<AsyncResult<CompositeFuture>> completer() { 
    if (cached_0 != null) {
      return cached_0;
    }
    Handler<AsyncResult<CompositeFuture>> ret = new Handler<AsyncResult<CompositeFuture>>() {
      public void handle(AsyncResult<CompositeFuture> ar) {
        if (ar.succeeded()) {
          delegate.completer().handle(io.vertx.core.Future.succeededFuture(ar.result().getDelegate()));
        } else {
          delegate.completer().handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    };
    cached_0 = ret;
    return ret;
  }

  /**
   * Handles a failure of this Future by returning the result of another Future.
   * If the mapper fails, then the returned future will be failed with this failure.
   * @param mapper A function which takes the exception of a failure and returns a new future.
   * @return A recovered future
   */
  public Future<CompositeFuture> recover(Function<Throwable,Future<CompositeFuture>> mapper) { 
    Future<CompositeFuture> ret = Future.newInstance(delegate.recover(new java.util.function.Function<java.lang.Throwable,io.vertx.core.Future<io.vertx.core.CompositeFuture>>() {
      public io.vertx.core.Future<io.vertx.core.CompositeFuture> apply(java.lang.Throwable arg) {
        Future<CompositeFuture> ret = mapper.apply(arg);
        return ret.getDelegate();
      }
    }), io.vertx.rxjava.core.CompositeFuture.__TYPE_ARG);
    return ret;
  }

  /**
   * Apply a <code>mapper</code> function on this future.<p>
   *
   * When this future fails, the <code>mapper</code> will be called with the completed value and this mapper
   * returns a value. This value will complete the future returned by this method call.<p>
   *
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future succeeds, the result will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the mapped future
   */
  public Future<CompositeFuture> otherwise(Function<Throwable,CompositeFuture> mapper) { 
    Future<CompositeFuture> ret = Future.newInstance(delegate.otherwise(new java.util.function.Function<java.lang.Throwable,io.vertx.core.CompositeFuture>() {
      public io.vertx.core.CompositeFuture apply(java.lang.Throwable arg) {
        CompositeFuture ret = mapper.apply(arg);
        return ret.getDelegate();
      }
    }), io.vertx.rxjava.core.CompositeFuture.__TYPE_ARG);
    return ret;
  }

  /**
   * Map the failure of a future to a specific <code>value</code>.<p>
   *
   * When this future fails, this <code>value</code> will complete the future returned by this method call.<p>
   *
   * When this future succeeds, the result will be propagated to the returned future.
   * @param value the value that eventually completes the mapped future
   * @return the mapped future
   */
  public Future<CompositeFuture> otherwise(CompositeFuture value) { 
    Future<CompositeFuture> ret = Future.newInstance(delegate.otherwise(value.getDelegate()), io.vertx.rxjava.core.CompositeFuture.__TYPE_ARG);
    return ret;
  }

  /**
   * Map the failure of a future to <code>null</code>.<p>
   *
   * This is a convenience for <code>future.otherwise((T) null)</code>.<p>
   *
   * When this future fails, the <code>null</code> value will complete the future returned by this method call.<p>
   *
   * When this future succeeds, the result will be propagated to the returned future.
   * @return the mapped future
   */
  public Future<CompositeFuture> otherwiseEmpty() { 
    Future<CompositeFuture> ret = Future.newInstance(delegate.otherwiseEmpty(), io.vertx.rxjava.core.CompositeFuture.__TYPE_ARG);
    return ret;
  }

  /**
   * Return a composite future, succeeded when all futures are succeeded, failed when any future is failed.
   * <p/>
   * The returned future fails as soon as one of <code>f1</code> or <code>f2</code> fails.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> CompositeFuture all(Future<T1> f1, Future<T2> f2) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#all} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> CompositeFuture all(Future<T1> f1, Future<T2> f2, Future<T3> f3) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#all} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> CompositeFuture all(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#all} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> CompositeFuture all(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4, Future<T5> f5) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#all} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> CompositeFuture all(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4, Future<T5> f5, Future<T6> f6) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#all} but with a list of futures.<p>
   *
   * When the list is empty, the returned future will be already completed.
   * @param futures 
   * @return 
   */
  public static CompositeFuture all(List<Future> futures) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * Return a composite future, succeeded when any futures is succeeded, failed when all futures are failed.
   * <p/>
   * The returned future succeeds as soon as one of <code>f1</code> or <code>f2</code> succeeds.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> CompositeFuture any(Future<T1> f1, Future<T2> f2) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#any} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> CompositeFuture any(Future<T1> f1, Future<T2> f2, Future<T3> f3) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#any} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> CompositeFuture any(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#any} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> CompositeFuture any(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4, Future<T5> f5) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#any} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> CompositeFuture any(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4, Future<T5> f5, Future<T6> f6) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#any} but with a list of futures.<p>
   *
   * When the list is empty, the returned future will be already completed.
   * @param futures 
   * @return 
   */
  public static CompositeFuture any(List<Future> futures) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * Return a composite future, succeeded when all futures are succeeded, failed when any future is failed.
   * <p/>
   * It always wait until all its futures are completed and will not fail as soon as one of <code>f1</code> or <code>f2</code> fails.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> CompositeFuture join(Future<T1> f1, Future<T2> f2) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#join} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> CompositeFuture join(Future<T1> f1, Future<T2> f2, Future<T3> f3) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#join} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> CompositeFuture join(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#join} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> CompositeFuture join(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4, Future<T5> f5) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#join} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> CompositeFuture join(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4, Future<T5> f5, Future<T6> f6) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(f1.getDelegate(), f2.getDelegate(), f3.getDelegate(), f4.getDelegate(), f5.getDelegate(), f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#join} but with a list of futures.<p>
   *
   * When the list is empty, the returned future will be already completed.
   * @param futures 
   * @return 
   */
  public static CompositeFuture join(List<Future> futures) { 
    CompositeFuture ret = CompositeFuture.newInstance(io.vertx.core.CompositeFuture.join(futures.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  public CompositeFuture setHandler(Handler<AsyncResult<CompositeFuture>> handler) { 
    delegate.setHandler(new Handler<AsyncResult<io.vertx.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.core.CompositeFuture> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(CompositeFuture.newInstance(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  @Deprecated()
  public Observable<CompositeFuture> setHandlerObservable() { 
    io.vertx.rx.java.ObservableFuture<CompositeFuture> handler = io.vertx.rx.java.RxHelper.observableFuture();
    setHandler(handler.toHandler());
    return handler;
  }

  public Single<CompositeFuture> rxSetHandler() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      setHandler(fut);
    }));
  }

  /**
   * Set this instance as result. Any handler will be called, if there is one, and the future will be marked as completed.
   */
  public void complete() { 
    delegate.complete();
  }

  /**
   * Try to set this instance as result. When it happens, any handler will be called, if there is one, and the future will be marked as completed.
   * @return false when the future is already completed
   */
  public boolean tryComplete() { 
    boolean ret = delegate.tryComplete();
    return ret;
  }

  /**
   * Returns a cause of a wrapped future
   * @param index the wrapped future index
   * @return 
   */
  public Throwable cause(int index) { 
    Throwable ret = delegate.cause(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is succeeded
   * @param index the wrapped future index
   * @return 
   */
  public boolean succeeded(int index) { 
    boolean ret = delegate.succeeded(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is failed
   * @param index the wrapped future index
   * @return 
   */
  public boolean failed(int index) { 
    boolean ret = delegate.failed(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is completed
   * @param index the wrapped future index
   * @return 
   */
  public boolean isComplete(int index) { 
    boolean ret = delegate.isComplete(index);
    return ret;
  }

  /**
   * Returns the result of a wrapped future
   * @param index the wrapped future index
   * @return 
   */
  public <T> T resultAt(int index) { 
    T ret = (T) delegate.resultAt(index);
    return ret;
  }

  /**
   * @return the number of wrapped future
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  private Handler<AsyncResult<CompositeFuture>> cached_0;

  public static  CompositeFuture newInstance(io.vertx.core.CompositeFuture arg) {
    return arg != null ? new CompositeFuture(arg) : null;
  }
}
