/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.core.datagram.DatagramSocket;
import io.vertx.rxjava.core.http.HttpServer;
import io.vertx.rxjava.core.shareddata.SharedData;
import io.vertx.rxjava.core.eventbus.EventBus;
import io.vertx.core.AsyncResult;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.rxjava.core.net.NetClient;
import io.vertx.core.VertxOptions;
import java.util.Set;
import io.vertx.core.net.NetClientOptions;
import io.vertx.rxjava.core.dns.DnsClient;
import io.vertx.core.net.NetServerOptions;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.rxjava.core.net.NetServer;
import io.vertx.core.DeploymentOptions;
import io.vertx.rxjava.core.file.FileSystem;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.Handler;
import io.vertx.rxjava.core.http.HttpClient;

/**
 * The entry point into the Vert.x Core API.
 * <p>
 * You use an instance of this class for functionality including:
 * <ul>
 *   <li>Creating TCP clients and servers</li>
 *   <li>Creating HTTP clients and servers</li>
 *   <li>Creating DNS clients</li>
 *   <li>Creating Datagram sockets</li>
 *   <li>Setting and cancelling periodic and one-shot timers</li>
 *   <li>Getting a reference to the event bus API</li>
 *   <li>Getting a reference to the file system API</li>
 *   <li>Getting a reference to the shared data API</li>
 *   <li>Deploying and undeploying verticles</li>
 * </ul>
 * <p>
 * Most functionality in Vert.x core is fairly low level.
 * <p>
 * To create an instance of this class you can use the static factory methods: {@link io.vertx.rxjava.core.Vertx#vertx},
 * {@link io.vertx.rxjava.core.Vertx#vertx} and {@link io.vertx.rxjava.core.Vertx#clusteredVertx}.
 * <p>
 * Please see the user manual for more detailed usage information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Vertx original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.Vertx.class)
public class Vertx implements Measured {

  public static final io.vertx.lang.rxjava.TypeArg<Vertx> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new Vertx((io.vertx.core.Vertx) obj),
    Vertx::getDelegate
  );

  private final io.vertx.core.Vertx delegate;
  
  public Vertx(io.vertx.core.Vertx delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.Vertx getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return true if the metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Creates a non clustered instance using default options.
   * @return the instance
   */
  public static Vertx vertx() { 
    Vertx ret = Vertx.newInstance(io.vertx.core.Vertx.vertx());
    return ret;
  }

  /**
   * Creates a non clustered instance using the specified options
   * @param options the options to use
   * @return the instance
   */
  public static Vertx vertx(VertxOptions options) { 
    Vertx ret = Vertx.newInstance(io.vertx.core.Vertx.vertx(options));
    return ret;
  }

  /**
   * Creates a clustered instance using the specified options.
   * <p>
   * The instance is created asynchronously and the resultHandler is called with the result when it is ready.
   * @param options the options to use
   * @param resultHandler the result handler that will receive the result
   */
  public static void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) { 
    io.vertx.core.Vertx.clusteredVertx(options, new Handler<AsyncResult<io.vertx.core.Vertx>>() {
      public void handle(AsyncResult<io.vertx.core.Vertx> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(Vertx.newInstance(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Creates a clustered instance using the specified options.
   * <p>
   * The instance is created asynchronously and the resultHandler is called with the result when it is ready.
   * @param options the options to use
   * @return 
   * @deprecated use {@link #rxClusteredVertx} instead
   */
  @Deprecated()
  public static Observable<Vertx> clusteredVertxObservable(VertxOptions options) { 
    io.vertx.rx.java.ObservableFuture<Vertx> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    clusteredVertx(options, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Creates a clustered instance using the specified options.
   * <p>
   * The instance is created asynchronously and the resultHandler is called with the result when it is ready.
   * @param options the options to use
   * @return 
   */
  public static Single<Vertx> rxClusteredVertx(VertxOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      clusteredVertx(options, fut);
    }));
  }

  /**
   * Gets the current context
   * @return The current context or null if no current context
   */
  public static Context currentContext() { 
    Context ret = Context.newInstance(io.vertx.core.Vertx.currentContext());
    return ret;
  }

  /**
   * Gets the current context, or creates one if there isn't one
   * @return The current context (created if didn't exist)
   */
  public Context getOrCreateContext() { 
    Context ret = Context.newInstance(delegate.getOrCreateContext());
    return ret;
  }

  /**
   * Create a TCP/SSL server using the specified options
   * @param options the options to use
   * @return the server
   */
  public NetServer createNetServer(NetServerOptions options) { 
    NetServer ret = NetServer.newInstance(delegate.createNetServer(options));
    return ret;
  }

  /**
   * Create a TCP/SSL server using default options
   * @return the server
   */
  public NetServer createNetServer() { 
    NetServer ret = NetServer.newInstance(delegate.createNetServer());
    return ret;
  }

  /**
   * Create a TCP/SSL client using the specified options
   * @param options the options to use
   * @return the client
   */
  public NetClient createNetClient(NetClientOptions options) { 
    NetClient ret = NetClient.newInstance(delegate.createNetClient(options));
    return ret;
  }

  /**
   * Create a TCP/SSL client using default options
   * @return the client
   */
  public NetClient createNetClient() { 
    NetClient ret = NetClient.newInstance(delegate.createNetClient());
    return ret;
  }

  /**
   * Create an HTTP/HTTPS server using the specified options
   * @param options the options to use
   * @return the server
   */
  public HttpServer createHttpServer(HttpServerOptions options) { 
    HttpServer ret = HttpServer.newInstance(delegate.createHttpServer(options));
    return ret;
  }

  /**
   * Create an HTTP/HTTPS server using default options
   * @return the server
   */
  public HttpServer createHttpServer() { 
    HttpServer ret = HttpServer.newInstance(delegate.createHttpServer());
    return ret;
  }

  /**
   * Create a HTTP/HTTPS client using the specified options
   * @param options the options to use
   * @return the client
   */
  public HttpClient createHttpClient(HttpClientOptions options) { 
    HttpClient ret = HttpClient.newInstance(delegate.createHttpClient(options));
    return ret;
  }

  /**
   * Create a HTTP/HTTPS client using default options
   * @return the client
   */
  public HttpClient createHttpClient() { 
    HttpClient ret = HttpClient.newInstance(delegate.createHttpClient());
    return ret;
  }

  /**
   * Create a datagram socket using the specified options
   * @param options the options to use
   * @return the socket
   */
  public DatagramSocket createDatagramSocket(DatagramSocketOptions options) { 
    DatagramSocket ret = DatagramSocket.newInstance(delegate.createDatagramSocket(options));
    return ret;
  }

  /**
   * Create a datagram socket using default options
   * @return the socket
   */
  public DatagramSocket createDatagramSocket() { 
    DatagramSocket ret = DatagramSocket.newInstance(delegate.createDatagramSocket());
    return ret;
  }

  /**
   * Get the filesystem object. There is a single instance of FileSystem per Vertx instance.
   * @return the filesystem object
   */
  public FileSystem fileSystem() { 
    if (cached_0 != null) {
      return cached_0;
    }
    FileSystem ret = FileSystem.newInstance(delegate.fileSystem());
    cached_0 = ret;
    return ret;
  }

  /**
   * Get the event bus object. There is a single instance of EventBus per Vertx instance.
   * @return the event bus object
   */
  public EventBus eventBus() { 
    if (cached_1 != null) {
      return cached_1;
    }
    EventBus ret = EventBus.newInstance(delegate.eventBus());
    cached_1 = ret;
    return ret;
  }

  /**
   * Create a DNS client to connect to a DNS server at the specified host and port
   * @param port the port
   * @param host the host
   * @return the DNS client
   */
  public DnsClient createDnsClient(int port, String host) { 
    DnsClient ret = DnsClient.newInstance(delegate.createDnsClient(port, host));
    return ret;
  }

  /**
   * Get the shared data object. There is a single instance of SharedData per Vertx instance.
   * @return the shared data object
   */
  public SharedData sharedData() { 
    if (cached_2 != null) {
      return cached_2;
    }
    SharedData ret = SharedData.newInstance(delegate.sharedData());
    cached_2 = ret;
    return ret;
  }

  /**
   * Set a one-shot timer to fire after <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setTimer(long delay, Handler<Long> handler) { 
    long ret = delegate.setTimer(delay, handler);
    return ret;
  }

  /**
   * Returns a one-shot timer as a read stream. The timer will be fired after <code>delay</code> milliseconds after
   * the  has been called.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @return the timer stream
   */
  public TimeoutStream timerStream(long delay) { 
    TimeoutStream ret = TimeoutStream.newInstance(delegate.timerStream(delay));
    return ret;
  }

  /**
   * Set a periodic timer to fire every <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setPeriodic(long delay, Handler<Long> handler) { 
    long ret = delegate.setPeriodic(delay, handler);
    return ret;
  }

  /**
   * Returns a periodic timer as a read stream. The timer will be fired every <code>delay</code> milliseconds after
   * the  has been called.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @return the periodic stream
   */
  public TimeoutStream periodicStream(long delay) { 
    TimeoutStream ret = TimeoutStream.newInstance(delegate.periodicStream(delay));
    return ret;
  }

  /**
   * Cancels the timer with the specified <code>id</code>.
   * @param id The id of the timer to cancel
   * @return true if the timer was successfully cancelled, or false if the timer does not exist.
   */
  public boolean cancelTimer(long id) { 
    boolean ret = delegate.cancelTimer(id);
    return ret;
  }

  /**
   * Puts the handler on the event queue for the current context so it will be run asynchronously ASAP after all
   * preceeding events have been handled.
   * @param action - a handler representing the action to execute
   */
  public void runOnContext(Handler<Void> action) { 
    delegate.runOnContext(action);
  }

  /**
   * Stop the the Vertx instance and release any resources held by it.
   * <p>
   * The instance cannot be used after it has been closed.
   * <p>
   * The actual close is asynchronous and may not complete until after the call has returned.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#close} but the completionHandler will be called when the close is complete
   * @param completionHandler The handler will be notified when the close is complete.
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#close} but the completionHandler will be called when the close is complete
   * @return 
   * @deprecated use {@link #rxClose} instead
   */
  @Deprecated()
  public Observable<Void> closeObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    close(completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#close} but the completionHandler will be called when the close is complete
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Deploy a verticle instance given a name.
   * <p>
   * Given the name, Vert.x selects a  instance to use to instantiate the verticle.
   * <p>
   * For the rules on how factories are selected please consult the user manual.
   * @param name the name.
   */
  public void deployVerticle(String name) { 
    delegate.deployVerticle(name);
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a String representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param name The identifier
   * @param completionHandler a handler which will be notified when the deployment is complete
   */
  public void deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) { 
    delegate.deployVerticle(name, completionHandler);
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a String representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param name The identifier
   * @return 
   * @deprecated use {@link #rxDeployVerticle} instead
   */
  @Deprecated()
  public Observable<String> deployVerticleObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<String> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    deployVerticle(name, completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a String representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param name The identifier
   * @return 
   */
  public Single<String> rxDeployVerticle(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      deployVerticle(name, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   */
  public void deployVerticle(String name, DeploymentOptions options) { 
    delegate.deployVerticle(name, options);
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   * @param completionHandler a handler which will be notified when the deployment is complete
   */
  public void deployVerticle(String name, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) { 
    delegate.deployVerticle(name, options, completionHandler);
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   * @return 
   * @deprecated use {@link #rxDeployVerticle} instead
   */
  @Deprecated()
  public Observable<String> deployVerticleObservable(String name, DeploymentOptions options) { 
    io.vertx.rx.java.ObservableFuture<String> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    deployVerticle(name, options, completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   * @return 
   */
  public Single<String> rxDeployVerticle(String name, DeploymentOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      deployVerticle(name, options, fut);
    }));
  }

  /**
   * Undeploy a verticle deployment.
   * <p>
   * The actual undeployment happens asynchronously and may not complete until after the method has returned.
   * @param deploymentID the deployment ID
   */
  public void undeploy(String deploymentID) { 
    delegate.undeploy(deploymentID);
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx #undeploy(String)} but the completionHandler will be notified when the undeployment is complete.
   * @param deploymentID the deployment ID
   * @param completionHandler a handler which will be notified when the undeployment is complete
   */
  public void undeploy(String deploymentID, Handler<AsyncResult<Void>> completionHandler) { 
    delegate.undeploy(deploymentID, completionHandler);
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx #undeploy(String)} but the completionHandler will be notified when the undeployment is complete.
   * @param deploymentID the deployment ID
   * @return 
   * @deprecated use {@link #rxUndeploy} instead
   */
  @Deprecated()
  public Observable<Void> undeployObservable(String deploymentID) { 
    io.vertx.rx.java.ObservableFuture<Void> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    undeploy(deploymentID, completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx #undeploy(String)} but the completionHandler will be notified when the undeployment is complete.
   * @param deploymentID the deployment ID
   * @return 
   */
  public Single<Void> rxUndeploy(String deploymentID) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      undeploy(deploymentID, fut);
    }));
  }

  /**
   * Return a Set of deployment IDs for the currently deployed deploymentIDs.
   * @return Set of deployment IDs
   */
  public Set<String> deploymentIDs() { 
    Set<String> ret = delegate.deploymentIDs();
    return ret;
  }

  /**
   * Is this Vert.x instance clustered?
   * @return true if clustered
   */
  public boolean isClustered() { 
    boolean ret = delegate.isClustered();
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (e.g. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.rxjava.core.Future#complete} or {@link io.vertx.rxjava.core.Future#complete} method, or the {@link io.vertx.rxjava.core.Future#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @param resultHandler handler that will be called when the blocking code is complete
   */
  public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>() {
      public void handle(io.vertx.core.Future<T> event) {
        blockingCodeHandler.handle(Future.newInstance(event, io.vertx.lang.rxjava.TypeArg.unknown()));
      }
    }, ordered, new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((T) ar.result()));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (e.g. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.rxjava.core.Future#complete} or {@link io.vertx.rxjava.core.Future#complete} method, or the {@link io.vertx.rxjava.core.Future#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return 
   * @deprecated use {@link #rxExecuteBlocking} instead
   */
  @Deprecated()
  public <T> Observable<T> executeBlockingObservable(Handler<Future<T>> blockingCodeHandler, boolean ordered) { 
    io.vertx.rx.java.ObservableFuture<T> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    executeBlocking(blockingCodeHandler, ordered, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (e.g. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.rxjava.core.Future#complete} or {@link io.vertx.rxjava.core.Future#complete} method, or the {@link io.vertx.rxjava.core.Future#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return 
   */
  public <T> Single<T> rxExecuteBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      executeBlocking(blockingCodeHandler, ordered, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @param resultHandler 
   */
  public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) { 
    delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>() {
      public void handle(io.vertx.core.Future<T> event) {
        blockingCodeHandler.handle(Future.newInstance(event, io.vertx.lang.rxjava.TypeArg.unknown()));
      }
    }, new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((T) ar.result()));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   * @deprecated use {@link #rxExecuteBlocking} instead
   */
  @Deprecated()
  public <T> Observable<T> executeBlockingObservable(Handler<Future<T>> blockingCodeHandler) { 
    io.vertx.rx.java.ObservableFuture<T> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    executeBlocking(blockingCodeHandler, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   */
  public <T> Single<T> rxExecuteBlocking(Handler<Future<T>> blockingCodeHandler) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      executeBlocking(blockingCodeHandler, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#createSharedWorkerExecutor} but with the {@link io.vertx.core.VertxOptions} <code>poolSize</code>.
   * @param name 
   * @return 
   */
  public WorkerExecutor createSharedWorkerExecutor(String name) { 
    WorkerExecutor ret = WorkerExecutor.newInstance(delegate.createSharedWorkerExecutor(name));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.Vertx#createSharedWorkerExecutor} but with the {@link io.vertx.core.VertxOptions} <code>maxExecuteTime</code>.
   * @param name 
   * @param poolSize 
   * @return 
   */
  public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize) { 
    WorkerExecutor ret = WorkerExecutor.newInstance(delegate.createSharedWorkerExecutor(name, poolSize));
    return ret;
  }

  /**
   * Create a named worker executor, the executor should be closed when it's not needed anymore to release
   * resources.<p/>
   *
   * This method can be called mutiple times with the same <code>name</code>. Executors with the same name will share
   * the same worker pool. The worker pool size and max execute time are set when the worker pool is created and
   * won't change after.<p>
   *
   * The worker pool is released when all the {@link io.vertx.rxjava.core.WorkerExecutor} sharing the same name are closed.
   * @param name the name of the worker executor
   * @param poolSize the size of the pool
   * @param maxExecuteTime the value of max worker execute time, in ns
   * @return the named worker executor
   */
  public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime) { 
    WorkerExecutor ret = WorkerExecutor.newInstance(delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime));
    return ret;
  }

  /**
   * Set a default exception handler for {@link io.vertx.rxjava.core.Context}, set on  at creation.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public Vertx exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  private FileSystem cached_0;
  private EventBus cached_1;
  private SharedData cached_2;

  public static  Vertx newInstance(io.vertx.core.Vertx arg) {
    return arg != null ? new Vertx(arg) : null;
  }
}
