/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.eventbus;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.rxjava.core.streams.WriteStream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a stream of message that can be written to.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageProducer original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.eventbus.MessageProducer.class)
public class MessageProducer<T> implements WriteStream<T> {

  public static final io.vertx.lang.rxjava.TypeArg<MessageProducer> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new MessageProducer((io.vertx.core.eventbus.MessageProducer) obj),
    MessageProducer::getDelegate
  );

  private final io.vertx.core.eventbus.MessageProducer delegate;
  public final io.vertx.lang.rxjava.TypeArg<T> __typeArg_0;
  
  public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rxjava.TypeArg.unknown();
  }

  public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate, io.vertx.lang.rxjava.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.eventbus.MessageProducer getDelegate() {
    return delegate;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.eventbus.MessageProducer#end} but writes some data to the stream before ending.
   * @param t 
   */
  public void end(T t) { 
    delegate.end(__typeArg_0.unwrap(t));
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.eventbus.MessageProducer#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Synonym for {@link io.vertx.rxjava.core.eventbus.MessageProducer#write}.
   * @param message the message to send
   * @return reference to this for fluency
   */
  public MessageProducer<T> send(T message) { 
    MessageProducer<T> ret = MessageProducer.newInstance(delegate.send(__typeArg_0.unwrap(message)), __typeArg_0);
    return ret;
  }

  public <R> MessageProducer<T> send(T message, Handler<AsyncResult<Message<R>>> replyHandler) { 
    MessageProducer<T> ret = MessageProducer.newInstance(delegate.send(__typeArg_0.unwrap(message), new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(Message.newInstance(ar.result(), io.vertx.lang.rxjava.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    }), __typeArg_0);
    return ret;
  }

  public MessageProducer<T> exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public MessageProducer<T> write(T data) { 
    delegate.write(__typeArg_0.unwrap(data));
    return this;
  }

  public MessageProducer<T> setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public MessageProducer<T> drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * Update the delivery options of this producer.
   * @param options the new options
   * @return this producer object
   */
  public MessageProducer<T> deliveryOptions(DeliveryOptions options) { 
    delegate.deliveryOptions(options);
    return this;
  }

  /**
   * @return The address to which the producer produces messages.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * Closes the producer, calls {@link io.vertx.rxjava.core.eventbus.MessageProducer#close}
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Closes the producer, this method should be called when the message producer is not used anymore.
   */
  public void close() { 
    delegate.close();
  }


  public static <T>MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg) {
    return arg != null ? new MessageProducer<T>(arg) : null;
  }

  public static <T>MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg, io.vertx.lang.rxjava.TypeArg<T> __typeArg_T) {
    return arg != null ? new MessageProducer<T>(arg, __typeArg_T) : null;
  }
}
