/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.http;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.streams.WriteStream;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.core.Handler;
import io.vertx.rxjava.core.net.SocketAddress;

/**
 * Base WebSocket implementation.
 * <p>
 * It implements both  and  so it can be used with
 * {@link io.vertx.rxjava.core.streams.Pump} to pump data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocketBase original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.http.WebSocketBase.class)
public interface WebSocketBase extends ReadStream<Buffer>,  WriteStream<Buffer> {

  io.vertx.core.http.WebSocketBase getDelegate();

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#end} but writes some data to the stream before ending.
   * @param t 
   */
  public void end(Buffer t);

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.http.WebSocketBase#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull();

  public WebSocketBase exceptionHandler(Handler<Throwable> handler);

  public WebSocketBase handler(Handler<Buffer> handler);

  public WebSocketBase pause();

  public WebSocketBase resume();

  public WebSocketBase endHandler(Handler<Void> endHandler);

  public WebSocketBase write(Buffer data);

  public WebSocketBase setWriteQueueMaxSize(int maxSize);

  public WebSocketBase drainHandler(Handler<Void> handler);

  /**
   * When a <code>Websocket</code> is created it automatically registers an event handler with the event bus - the ID of that
   * handler is given by this method.
   * <p>
   * Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the binary handler id
   */
  public String binaryHandlerID();

  /**
   * When a <code>Websocket</code> is created it automatically registers an event handler with the eventbus, the ID of that
   * handler is given by <code>textHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a text frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return 
   */
  public String textHandlerID();

  /**
   * Write a WebSocket frame to the connection
   * @param frame the frame to write
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writeFrame(WebSocketFrame frame);

  /**
   * Write a final WebSocket text frame to the connection
   * @param text The text to write
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writeFinalTextFrame(String text);

  /**
   * Write a final WebSocket binary frame to the connection
   * @param data The data to write
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writeFinalBinaryFrame(Buffer data);

  /**
   * Writes a (potentially large) piece of binary data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param data the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writeBinaryMessage(Buffer data);

  /**
   * Writes a (potentially large) piece of text data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param text the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writeTextMessage(String text);

  /**
   * Set a close handler. This will be called when the WebSocket is closed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase closeHandler(Handler<Void> handler);

  /**
   * Set a frame handler on the connection. This handler will be called when frames are read on the connection.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase frameHandler(Handler<WebSocketFrame> handler);

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * , but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase textMessageHandler(Handler<String> handler);

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.rxjava.core.http.WebSocketBase#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.rxjava.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase binaryMessageHandler(Handler<Buffer> handler);

  /**
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   */
  public void end();

  /**
   * Close the WebSocket.
   */
  public void close();

  /**
   * @return the remote address for this socket
   */
  public SocketAddress remoteAddress();

  /**
   * @return the local address for this socket
   */
  public SocketAddress localAddress();

  /**
   * @return true if this {@link io.vertx.rxjava.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl();


  public static  WebSocketBase newInstance(io.vertx.core.http.WebSocketBase arg) {
    return arg != null ? new WebSocketBaseImpl(arg) : null;
  }
}

class WebSocketBaseImpl implements WebSocketBase {
  private final io.vertx.core.http.WebSocketBase delegate;
  
  public WebSocketBaseImpl(io.vertx.core.http.WebSocketBase delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.http.WebSocketBase getDelegate() {
    return delegate;
  }

  private rx.Observable<Buffer> observable;

  public synchronized rx.Observable<Buffer> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
      observable = io.vertx.rx.java.RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#end} but writes some data to the stream before ending.
   * @param t 
   */
  public void end(Buffer t) { 
    delegate.end(t.getDelegate());
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.http.WebSocketBase#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public WebSocketBase exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public WebSocketBase handler(Handler<Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(Buffer.newInstance(event));
      }
    });
    return this;
  }

  public WebSocketBase pause() { 
    delegate.pause();
    return this;
  }

  public WebSocketBase resume() { 
    delegate.resume();
    return this;
  }

  public WebSocketBase endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public WebSocketBase write(Buffer data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  public WebSocketBase setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public WebSocketBase drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * When a <code>Websocket</code> is created it automatically registers an event handler with the event bus - the ID of that
   * handler is given by this method.
   * <p>
   * Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the binary handler id
   */
  public String binaryHandlerID() { 
    String ret = delegate.binaryHandlerID();
    return ret;
  }

  /**
   * When a <code>Websocket</code> is created it automatically registers an event handler with the eventbus, the ID of that
   * handler is given by <code>textHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a text frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return 
   */
  public String textHandlerID() { 
    String ret = delegate.textHandlerID();
    return ret;
  }

  /**
   * Write a WebSocket frame to the connection
   * @param frame the frame to write
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writeFrame(WebSocketFrame frame) { 
    delegate.writeFrame(frame.getDelegate());
    return this;
  }

  /**
   * Write a final WebSocket text frame to the connection
   * @param text The text to write
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writeFinalTextFrame(String text) { 
    delegate.writeFinalTextFrame(text);
    return this;
  }

  /**
   * Write a final WebSocket binary frame to the connection
   * @param data The data to write
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writeFinalBinaryFrame(Buffer data) { 
    delegate.writeFinalBinaryFrame(data.getDelegate());
    return this;
  }

  /**
   * Writes a (potentially large) piece of binary data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param data the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writeBinaryMessage(Buffer data) { 
    delegate.writeBinaryMessage(data.getDelegate());
    return this;
  }

  /**
   * Writes a (potentially large) piece of text data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param text the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writeTextMessage(String text) { 
    delegate.writeTextMessage(text);
    return this;
  }

  /**
   * Set a close handler. This will be called when the WebSocket is closed.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Set a frame handler on the connection. This handler will be called when frames are read on the connection.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase frameHandler(Handler<WebSocketFrame> handler) { 
    delegate.frameHandler(new Handler<io.vertx.core.http.WebSocketFrame>() {
      public void handle(io.vertx.core.http.WebSocketFrame event) {
        handler.handle(WebSocketFrame.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * , but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase textMessageHandler(Handler<String> handler) { 
    delegate.textMessageHandler(handler);
    return this;
  }

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.rxjava.core.http.WebSocketBase#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.rxjava.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase binaryMessageHandler(Handler<Buffer> handler) { 
    delegate.binaryMessageHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Close the WebSocket.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @return the remote address for this socket
   */
  public SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    SocketAddress ret = SocketAddress.newInstance(delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this socket
   */
  public SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    SocketAddress ret = SocketAddress.newInstance(delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.rxjava.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  private SocketAddress cached_0;
  private SocketAddress cached_1;
}
