/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.net.SocketAddress;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.http.HttpConnection.class)
public class HttpConnection {
    public static final TypeArg<HttpConnection> __TYPE_ARG = new TypeArg<HttpConnection>(obj -> new HttpConnection((io.vertx.core.http.HttpConnection)obj), HttpConnection::getDelegate);
    private final io.vertx.core.http.HttpConnection delegate;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public HttpConnection(io.vertx.core.http.HttpConnection delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.http.HttpConnection getDelegate() {
        return this.delegate;
    }

    public int getWindowSize() {
        int ret = this.delegate.getWindowSize();
        return ret;
    }

    public HttpConnection setWindowSize(int windowSize) {
        this.delegate.setWindowSize(windowSize);
        return this;
    }

    public HttpConnection goAway(long errorCode) {
        this.delegate.goAway(errorCode);
        return this;
    }

    public HttpConnection goAway(long errorCode, int lastStreamId) {
        this.delegate.goAway(errorCode, lastStreamId);
        return this;
    }

    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        this.delegate.goAway(errorCode, lastStreamId, debugData.getDelegate());
        return this;
    }

    public HttpConnection goAwayHandler(Handler<GoAway> handler) {
        this.delegate.goAwayHandler(handler);
        return this;
    }

    public HttpConnection shutdownHandler(Handler<Void> handler) {
        this.delegate.shutdownHandler(handler);
        return this;
    }

    public HttpConnection shutdown() {
        this.delegate.shutdown();
        return this;
    }

    public HttpConnection shutdown(long timeoutMs) {
        this.delegate.shutdown(timeoutMs);
        return this;
    }

    public HttpConnection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public void close() {
        this.delegate.close();
    }

    public Http2Settings settings() {
        Http2Settings ret = this.delegate.settings();
        return ret;
    }

    public HttpConnection updateSettings(Http2Settings settings) {
        this.delegate.updateSettings(settings);
        return this;
    }

    public HttpConnection updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.updateSettings(settings, completionHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> updateSettingsObservable(Http2Settings settings) {
        ObservableFuture<Void> completionHandler = RxHelper.observableFuture();
        this.updateSettings(settings, completionHandler.toHandler());
        return completionHandler;
    }

    public Single<Void> rxUpdateSettings(Http2Settings settings) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.updateSettings(settings, (Handler<AsyncResult<Void>>)fut)));
    }

    public Http2Settings remoteSettings() {
        Http2Settings ret = this.delegate.remoteSettings();
        return ret;
    }

    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        this.delegate.remoteSettingsHandler(handler);
        return this;
    }

    public HttpConnection ping(Buffer data, final Handler<AsyncResult<Buffer>> pongHandler) {
        this.delegate.ping(data.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>(){

            public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
                if (ar.succeeded()) {
                    pongHandler.handle((Object)Future.succeededFuture((Object)Buffer.newInstance((io.vertx.core.buffer.Buffer)ar.result())));
                } else {
                    pongHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<Buffer> pingObservable(Buffer data) {
        ObservableFuture<Buffer> pongHandler = RxHelper.observableFuture();
        this.ping(data, pongHandler.toHandler());
        return pongHandler;
    }

    public Single<Buffer> rxPing(Buffer data) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.ping(data, (Handler<AsyncResult<Buffer>>)fut)));
    }

    public HttpConnection pingHandler(final Handler<Buffer> handler) {
        this.delegate.pingHandler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    public HttpConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public static HttpConnection newInstance(io.vertx.core.http.HttpConnection arg) {
        return arg != null ? new HttpConnection(arg) : null;
    }
}

