/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.net;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.RxGen;
import io.vertx.lang.rxjava.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.rxjava.core.net.NetSocket;
import io.vertx.rxjava.core.net.SocketAddress;
import io.vertx.rxjava.core.streams.ReadStream;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.net.NetServer.class)
public class NetServer
implements Measured {
    public static final TypeArg<NetServer> __TYPE_ARG = new TypeArg<NetServer>(obj -> new NetServer((io.vertx.core.net.NetServer)obj), NetServer::getDelegate);
    private final io.vertx.core.net.NetServer delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetServer that = (NetServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetServer(io.vertx.core.net.NetServer delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.net.NetServer getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public ReadStream<NetSocket> connectStream() {
        ReadStream<NetSocket> ret = ReadStream.newInstance(this.delegate.connectStream(), NetSocket.__TYPE_ARG);
        return ret;
    }

    public NetServer connectHandler(final Handler<NetSocket> handler) {
        NetServer ret = NetServer.newInstance(this.delegate.connectHandler((Handler)new Handler<io.vertx.core.net.NetSocket>(){

            public void handle(io.vertx.core.net.NetSocket event) {
                handler.handle((Object)NetSocket.newInstance(event));
            }
        }));
        return ret;
    }

    public NetServer listen() {
        this.delegate.listen();
        return this;
    }

    public NetServer listen(final Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen((Handler)new Handler<AsyncResult<io.vertx.core.net.NetServer>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<NetServer> listenObservable() {
        ObservableFuture<NetServer> listenHandler = RxHelper.observableFuture();
        this.listen(listenHandler.toHandler());
        return listenHandler;
    }

    public Single<NetServer> rxListen() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.listen((Handler<AsyncResult<NetServer>>)fut)));
    }

    public NetServer listen(int port, String host) {
        this.delegate.listen(port, host);
        return this;
    }

    public NetServer listen(int port, String host, final Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetServer>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<NetServer> listenObservable(int port, String host) {
        ObservableFuture<NetServer> listenHandler = RxHelper.observableFuture();
        this.listen(port, host, listenHandler.toHandler());
        return listenHandler;
    }

    public Single<NetServer> rxListen(int port, String host) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.listen(port, host, (Handler<AsyncResult<NetServer>>)fut)));
    }

    public NetServer listen(int port) {
        this.delegate.listen(port);
        return this;
    }

    public NetServer listen(int port, final Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen(port, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetServer>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<NetServer> listenObservable(int port) {
        ObservableFuture<NetServer> listenHandler = RxHelper.observableFuture();
        this.listen(port, listenHandler.toHandler());
        return listenHandler;
    }

    public Single<NetServer> rxListen(int port) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.listen(port, (Handler<AsyncResult<NetServer>>)fut)));
    }

    public NetServer listen(SocketAddress localAddress) {
        this.delegate.listen(localAddress.getDelegate());
        return this;
    }

    public NetServer listen(SocketAddress localAddress, final Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen(localAddress.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.net.NetServer>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<NetServer> listenObservable(SocketAddress localAddress) {
        ObservableFuture<NetServer> listenHandler = RxHelper.observableFuture();
        this.listen(localAddress, listenHandler.toHandler());
        return listenHandler;
    }

    public Single<NetServer> rxListen(SocketAddress localAddress) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.listen(localAddress, (Handler<AsyncResult<NetServer>>)fut)));
    }

    public NetServer exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    @Deprecated
    public Observable<Void> closeObservable() {
        ObservableFuture<Void> completionHandler = RxHelper.observableFuture();
        this.close(completionHandler.toHandler());
        return completionHandler;
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public static NetServer newInstance(io.vertx.core.net.NetServer arg) {
        return arg != null ? new NetServer(arg) : null;
    }
}

