/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.impl;

import io.vertx.core.streams.WriteStream;
import io.vertx.rx.java.WriteStreamSubscriber;
import java.util.Objects;
import java.util.function.Function;
import rx.functions.Action0;
import rx.functions.Action1;

public class WriteStreamSubscriberImpl<R, T>
extends WriteStreamSubscriber<R> {
    private static final int BATCH_SIZE = 16;
    private final WriteStream<T> writeStream;
    private final Function<R, T> mapping;
    private int outstanding;
    private Action1<Throwable> observableErrorHandler;
    private Action0 observableCompleteHandler;
    private Action1<Throwable> writeStreamExceptionHandler;

    public WriteStreamSubscriberImpl(WriteStream<T> writeStream, Function<R, T> mapping) {
        Objects.requireNonNull(writeStream, "writeStream");
        Objects.requireNonNull(mapping, "mapping");
        this.writeStream = writeStream;
        this.mapping = mapping;
    }

    public void onStart() {
        this.writeStream.exceptionHandler(t -> {
            Action1<Throwable> a;
            this.unsubscribe();
            WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
            synchronized (writeStreamSubscriberImpl) {
                a = this.writeStreamExceptionHandler;
            }
            if (a != null) {
                a.call(t);
            }
        });
        this.writeStream.drainHandler(v -> this.requestMore());
        this.requestMore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(R r) {
        this.writeStream.write(this.mapping.apply(r));
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            --this.outstanding;
        }
        if (!this.writeStream.writeQueueFull()) {
            this.requestMore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        Action1<Throwable> a;
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            a = this.observableErrorHandler;
        }
        if (a != null) {
            a.call((Object)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleted() {
        Action0 a;
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            a = this.observableCompleteHandler;
        }
        this.writeStream.end();
        if (a != null) {
            a.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMore() {
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            if (this.outstanding > 0) {
                return;
            }
            this.outstanding = 16;
        }
        this.request(16L);
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onError(Action1<Throwable> handler) {
        this.observableErrorHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onComplete(Action0 handler) {
        this.observableCompleteHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onWriteStreamError(Action1<Throwable> handler) {
        this.writeStreamExceptionHandler = handler;
        return this;
    }
}

